package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_NCS_DOM_LIM category identify the
 *  start and end points of polypeptide chain segments
 *  that form all or part of a domain in an ensemble of domains
 *  related by noncrystallographic symmetry.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_dom_limCategory>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="A" beg_label_comp_id="PRO" beg_label_seq_id="1" end_label_alt_id="" end_label_asym_id="A" end_label_comp_id="GLY" end_label_seq_id="29"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="B" beg_label_comp_id="PRO" beg_label_seq_id="31" end_label_alt_id="" end_label_asym_id="B" end_label_comp_id="GLY" end_label_seq_id="59"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d1" beg_label_alt_id="" beg_label_asym_id="C" beg_label_comp_id="PRO" beg_label_seq_id="61" end_label_alt_id="" end_label_asym_id="B" end_label_comp_id="GLY" end_label_seq_id="89"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="D" beg_label_comp_id="PRO" beg_label_seq_id="91" end_label_alt_id="" end_label_asym_id="D" end_label_comp_id="GLY" end_label_seq_id="119"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="E" beg_label_comp_id="PRO" beg_label_seq_id="121" end_label_alt_id="" end_label_asym_id="E" end_label_comp_id="GLY" end_label_seq_id="149"></PDBx:struct_ncs_dom_lim>
 *  <PDBx:struct_ncs_dom_lim dom_id="d2" beg_label_alt_id="" beg_label_asym_id="F" beg_label_comp_id="PRO" beg_label_seq_id="151" end_label_alt_id="" end_label_asym_id="F" end_label_comp_id="GLY" end_label_seq_id="179"></PDBx:struct_ncs_dom_lim>
 *  </PDBx:struct_ncs_dom_limCategory>
 * </pre>
 */
public class Struct_ncs_dom_lim extends org.pdb.beans.Struct_ncs_dom_lim implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ncs_dom_lim";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ncs_dom_lim()
	{
	}

	/** Full constructor */
	public Struct_ncs_dom_lim(
		Datablock datablock,
		java.lang.String beg_auth_asym_id,
		java.lang.String beg_auth_comp_id,
		java.lang.String beg_auth_seq_id,
		java.lang.String beg_label_alt_id,
		java.lang.String beg_label_asym_id,
		java.lang.String beg_label_comp_id,
		java.lang.Integer beg_label_seq_id,
		java.lang.String dom_id,
		java.lang.String end_auth_asym_id,
		java.lang.String end_auth_comp_id,
		java.lang.String end_auth_seq_id,
		java.lang.String end_label_alt_id,
		java.lang.String end_label_asym_id,
		java.lang.String end_label_comp_id,
		java.lang.Integer end_label_seq_id,
		java.lang.Integer pdbx_component_id,
		java.lang.Float pdbx_refine_code)
	{
		this.datablock = datablock;
		this.beg_auth_asym_id = beg_auth_asym_id;
		this.beg_auth_comp_id = beg_auth_comp_id;
		this.beg_auth_seq_id = beg_auth_seq_id;
		this.beg_label_alt_id = beg_label_alt_id;
		this.beg_label_asym_id = beg_label_asym_id;
		this.beg_label_comp_id = beg_label_comp_id;
		this.beg_label_seq_id = beg_label_seq_id;
		this.dom_id = dom_id;
		this.end_auth_asym_id = end_auth_asym_id;
		this.end_auth_comp_id = end_auth_comp_id;
		this.end_auth_seq_id = end_auth_seq_id;
		this.end_label_alt_id = end_label_alt_id;
		this.end_label_asym_id = end_label_asym_id;
		this.end_label_comp_id = end_label_comp_id;
		this.end_label_seq_id = end_label_seq_id;
		this.pdbx_component_id = pdbx_component_id;
		this.pdbx_refine_code = pdbx_refine_code;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ncs_dom_lim");
		sb.append("\n");
		if (beg_auth_asym_id != null)
		{
			sb.append("beg_auth_asym_id = ");
			sb.append(beg_auth_asym_id);
			sb.append('\n');
		}
		if (beg_auth_comp_id != null)
		{
			sb.append("beg_auth_comp_id = ");
			sb.append(beg_auth_comp_id);
			sb.append('\n');
		}
		if (beg_auth_seq_id != null)
		{
			sb.append("beg_auth_seq_id = ");
			sb.append(beg_auth_seq_id);
			sb.append('\n');
		}
		if (beg_label_alt_id != null)
		{
			sb.append("beg_label_alt_id = ");
			sb.append(beg_label_alt_id);
			sb.append('\n');
		}
		if (beg_label_asym_id != null)
		{
			sb.append("beg_label_asym_id = ");
			sb.append(beg_label_asym_id);
			sb.append('\n');
		}
		if (beg_label_comp_id != null)
		{
			sb.append("beg_label_comp_id = ");
			sb.append(beg_label_comp_id);
			sb.append('\n');
		}
		if (beg_label_seq_id != null)
		{
			sb.append("beg_label_seq_id = ");
			sb.append(beg_label_seq_id);
			sb.append('\n');
		}
		if (dom_id != null)
		{
			sb.append("dom_id = ");
			sb.append(dom_id);
			sb.append('\n');
		}
		if (end_auth_asym_id != null)
		{
			sb.append("end_auth_asym_id = ");
			sb.append(end_auth_asym_id);
			sb.append('\n');
		}
		if (end_auth_comp_id != null)
		{
			sb.append("end_auth_comp_id = ");
			sb.append(end_auth_comp_id);
			sb.append('\n');
		}
		if (end_auth_seq_id != null)
		{
			sb.append("end_auth_seq_id = ");
			sb.append(end_auth_seq_id);
			sb.append('\n');
		}
		if (end_label_alt_id != null)
		{
			sb.append("end_label_alt_id = ");
			sb.append(end_label_alt_id);
			sb.append('\n');
		}
		if (end_label_asym_id != null)
		{
			sb.append("end_label_asym_id = ");
			sb.append(end_label_asym_id);
			sb.append('\n');
		}
		if (end_label_comp_id != null)
		{
			sb.append("end_label_comp_id = ");
			sb.append(end_label_comp_id);
			sb.append('\n');
		}
		if (end_label_seq_id != null)
		{
			sb.append("end_label_seq_id = ");
			sb.append(end_label_seq_id);
			sb.append('\n');
		}
		if (pdbx_component_id != null)
		{
			sb.append("pdbx_component_id = ");
			sb.append(pdbx_component_id);
			sb.append('\n');
		}
		if (pdbx_refine_code != null)
		{
			sb.append("pdbx_refine_code = ");
			sb.append(pdbx_refine_code);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		beg_auth_asym_id = null;
		beg_auth_comp_id = null;
		beg_auth_seq_id = null;
		beg_label_alt_id = null;
		beg_label_asym_id = null;
		beg_label_comp_id = null;
		beg_label_seq_id = null;
		dom_id = null;
		end_auth_asym_id = null;
		end_auth_comp_id = null;
		end_auth_seq_id = null;
		end_label_alt_id = null;
		end_label_asym_id = null;
		end_label_comp_id = null;
		end_label_seq_id = null;
		pdbx_component_id = null;
		pdbx_refine_code = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ncs_dom_lim)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ncs_dom_lim>\n");
			if (beg_auth_asym_id != null) ow.write(indent + " <PDBx:beg_auth_asym_id>" + beg_auth_asym_id + "</PDBx:beg_auth_asym_id>\n");
			if (beg_auth_comp_id != null) ow.write(indent + " <PDBx:beg_auth_comp_id>" + beg_auth_comp_id + "</PDBx:beg_auth_comp_id>\n");
			if (beg_auth_seq_id != null) ow.write(indent + " <PDBx:beg_auth_seq_id>" + beg_auth_seq_id + "</PDBx:beg_auth_seq_id>\n");
			if (beg_label_alt_id != null) ow.write(indent + " <PDBx:beg_label_alt_id>" + beg_label_alt_id + "</PDBx:beg_label_alt_id>\n");
			if (beg_label_asym_id != null) ow.write(indent + " <PDBx:beg_label_asym_id>" + beg_label_asym_id + "</PDBx:beg_label_asym_id>\n");
			if (beg_label_comp_id != null) ow.write(indent + " <PDBx:beg_label_comp_id>" + beg_label_comp_id + "</PDBx:beg_label_comp_id>\n");
			if (beg_label_seq_id != null) ow.write(indent + " <PDBx:beg_label_seq_id>" + beg_label_seq_id + "</PDBx:beg_label_seq_id>\n");
			if (dom_id != null) ow.write(indent + " <PDBx:dom_id>" + dom_id + "</PDBx:dom_id>\n");
			if (end_auth_asym_id != null) ow.write(indent + " <PDBx:end_auth_asym_id>" + end_auth_asym_id + "</PDBx:end_auth_asym_id>\n");
			if (end_auth_comp_id != null) ow.write(indent + " <PDBx:end_auth_comp_id>" + end_auth_comp_id + "</PDBx:end_auth_comp_id>\n");
			if (end_auth_seq_id != null) ow.write(indent + " <PDBx:end_auth_seq_id>" + end_auth_seq_id + "</PDBx:end_auth_seq_id>\n");
			if (end_label_alt_id != null) ow.write(indent + " <PDBx:end_label_alt_id>" + end_label_alt_id + "</PDBx:end_label_alt_id>\n");
			if (end_label_asym_id != null) ow.write(indent + " <PDBx:end_label_asym_id>" + end_label_asym_id + "</PDBx:end_label_asym_id>\n");
			if (end_label_comp_id != null) ow.write(indent + " <PDBx:end_label_comp_id>" + end_label_comp_id + "</PDBx:end_label_comp_id>\n");
			if (end_label_seq_id != null) ow.write(indent + " <PDBx:end_label_seq_id>" + end_label_seq_id + "</PDBx:end_label_seq_id>\n");
			if (pdbx_component_id != null) ow.write(indent + " <PDBx:pdbx_component_id>" + pdbx_component_id + "</PDBx:pdbx_component_id>\n");
			if (pdbx_refine_code != null) ow.write(indent + " <PDBx:pdbx_refine_code>" + pdbx_refine_code + "</PDBx:pdbx_refine_code>\n");
			ow.write(indent + "</PDBx:struct_ncs_dom_lim>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
