package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_NCS_ENS category record information
 *  about ensembles of domains related by noncrystallographic
 *  symmetry. The point group of the ensemble when taken as a
 *  whole may be specified, as well as any special aspects of the
 *  ensemble that require description.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_ensCategory>
 *  <PDBx:struct_ncs_ens id="en1">
 *  <PDBx:details> The ensemble represents the pseudo-twofold symmetry
 *  between domains d1 and d2.</PDBx:details>
 *  </PDBx:struct_ncs_ens>
 *  </PDBx:struct_ncs_ensCategory>
 * </pre>
 */
public class Struct_ncs_ens extends org.pdb.beans.Struct_ncs_ens implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ncs_ens";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ncs_ens()
	{
	}

	/** Full constructor */
	public Struct_ncs_ens(
		Datablock datablock,
		java.lang.String details,
		java.lang.String id_,
		java.lang.String point_group)
	{
		this.datablock = datablock;
		this.details = details;
		this.id_ = id_;
		this.point_group = point_group;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ncs_ens");
		sb.append("\n");
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (point_group != null)
		{
			sb.append("point_group = ");
			sb.append(point_group);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		details = null;
		id_ = null;
		point_group = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ncs_ens)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ncs_ens>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (point_group != null) ow.write(indent + " <PDBx:point_group>" + point_group + "</PDBx:point_group>\n");
			ow.write(indent + "</PDBx:struct_ncs_ens>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
