package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_NCS_ENS_GEN category list domains
 *  related by a noncrystallographic symmetry operation and
 *  identify the operator.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for the collagen-like
 *  peptide, HYP-.
 *  <PDBx:struct_ncs_ens_genCategory>
 *  <PDBx:struct_ncs_ens_gen dom_id_1="d1" dom_id_2="d2" ens_id="en1" oper_id="ncsop1"></PDBx:struct_ncs_ens_gen>
 *  </PDBx:struct_ncs_ens_genCategory>
 * </pre>
 */
public class Struct_ncs_ens_gen extends org.pdb.beans.Struct_ncs_ens_gen implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ncs_ens_gen";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ncs_ens_gen()
	{
	}

	/** Full constructor */
	public Struct_ncs_ens_gen(
		Datablock datablock,
		java.lang.String dom_id_1,
		java.lang.String dom_id_2,
		java.lang.String ens_id,
		java.lang.String oper_id)
	{
		this.datablock = datablock;
		this.dom_id_1 = dom_id_1;
		this.dom_id_2 = dom_id_2;
		this.ens_id = ens_id;
		this.oper_id = oper_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ncs_ens_gen");
		sb.append("\n");
		if (dom_id_1 != null)
		{
			sb.append("dom_id_1 = ");
			sb.append(dom_id_1);
			sb.append('\n');
		}
		if (dom_id_2 != null)
		{
			sb.append("dom_id_2 = ");
			sb.append(dom_id_2);
			sb.append('\n');
		}
		if (ens_id != null)
		{
			sb.append("ens_id = ");
			sb.append(ens_id);
			sb.append('\n');
		}
		if (oper_id != null)
		{
			sb.append("oper_id = ");
			sb.append(oper_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		dom_id_1 = null;
		dom_id_2 = null;
		ens_id = null;
		oper_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ncs_ens_gen)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ncs_ens_gen>\n");
			if (dom_id_1 != null) ow.write(indent + " <PDBx:dom_id_1>" + dom_id_1 + "</PDBx:dom_id_1>\n");
			if (dom_id_2 != null) ow.write(indent + " <PDBx:dom_id_2>" + dom_id_2 + "</PDBx:dom_id_2>\n");
			if (ens_id != null) ow.write(indent + " <PDBx:ens_id>" + ens_id + "</PDBx:ens_id>\n");
			if (oper_id != null) ow.write(indent + " <PDBx:oper_id>" + oper_id + "</PDBx:oper_id>\n");
			ow.write(indent + "</PDBx:struct_ncs_ens_gen>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
