package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_REF category allow the author of a
 *  data block to relate the entities or biological units
 *  described in the data block to information archived in external
 *  databases.
 *  
 *  For references to the sequence of a polymer, the value of
 *  the data item  attribute seq_align in category struct_ref is used to indicate
 *  whether the correspondence between the sequence of the entity
 *  or biological unit in the data block and the sequence in the
 *  referenced database entry is 'complete' or 'partial'. If
 *  this value is 'partial', the region (or regions) of the
 *  alignment may be delimited using data items in the
 *  STRUCT_REF_SEQ category.
 *  
 *  Similarly, the value of  attribute seq_dif in category struct_ref is used to indicate
 *  whether the two sequences contain point differences. If the
 *  value is 'yes', the differences may be identified and annotated
 *  using data items in the STRUCT_REF_SEQ_DIF category.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_refCategory>
 *  <PDBx:struct_ref id="1">
 *  <PDBx:entity_id>1</PDBx:entity_id>
 *  <PDBx:db_name>Genbank</PDBx:db_name>
 *  <PDBx:db_code>12345</PDBx:db_code>
 *  <PDBx:seq_align>entire</PDBx:seq_align>
 *  <PDBx:seq_dif>yes</PDBx:seq_dif>
 *  </PDBx:struct_ref>
 *  <PDBx:struct_ref id="2">
 *  <PDBx:entity_id xsi:nil="true" />
 *  <PDBx:biol_id>2</PDBx:biol_id>
 *  <PDBx:db_name>PDB</PDBx:db_name>
 *  <PDBx:db_code>1ABC</PDBx:db_code>
 *  <PDBx:details> The structure of the closely related compound,
 *  isobutyryl-pepstatin (pepstatin A) in complex with
 *  rhizopuspepsin</PDBx:details>
 *  </PDBx:struct_ref>
 *  </PDBx:struct_refCategory>
 * </pre>
 */
public class Struct_ref extends org.pdb.beans.Struct_ref implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ref";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ref()
	{
	}

	/** Full constructor */
	public Struct_ref(
		Datablock datablock,
		java.lang.String biol_id,
		java.lang.String db_code,
		java.lang.String db_name,
		java.lang.String details,
		java.lang.String entity_id,
		java.lang.String id_,
		java.lang.String pdbx_align_begin,
		java.lang.String pdbx_db_accession,
		java.lang.String pdbx_seq_one_letter_code,
		java.lang.String seq_align,
		java.lang.String seq_dif)
	{
		this.datablock = datablock;
		this.biol_id = biol_id;
		this.db_code = db_code;
		this.db_name = db_name;
		this.details = details;
		this.entity_id = entity_id;
		this.id_ = id_;
		this.pdbx_align_begin = pdbx_align_begin;
		this.pdbx_db_accession = pdbx_db_accession;
		this.pdbx_seq_one_letter_code = org.pdb.ormapping.util.Field.removeCrLf(pdbx_seq_one_letter_code);
		this.seq_align = seq_align;
		this.seq_dif = seq_dif;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ref");
		sb.append("\n");
		if (biol_id != null)
		{
			sb.append("biol_id = ");
			sb.append(biol_id);
			sb.append('\n');
		}
		if (db_code != null)
		{
			sb.append("db_code = ");
			sb.append(db_code);
			sb.append('\n');
		}
		if (db_name != null)
		{
			sb.append("db_name = ");
			sb.append(db_name);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (entity_id != null)
		{
			sb.append("entity_id = ");
			sb.append(entity_id);
			sb.append('\n');
		}
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pdbx_align_begin != null)
		{
			sb.append("pdbx_align_begin = ");
			sb.append(pdbx_align_begin);
			sb.append('\n');
		}
		if (pdbx_db_accession != null)
		{
			sb.append("pdbx_db_accession = ");
			sb.append(pdbx_db_accession);
			sb.append('\n');
		}
		if (pdbx_seq_one_letter_code != null)
		{
			sb.append("pdbx_seq_one_letter_code = ");
			sb.append(pdbx_seq_one_letter_code);
			sb.append('\n');
		}
		if (seq_align != null)
		{
			sb.append("seq_align = ");
			sb.append(seq_align);
			sb.append('\n');
		}
		if (seq_dif != null)
		{
			sb.append("seq_dif = ");
			sb.append(seq_dif);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		biol_id = null;
		db_code = null;
		db_name = null;
		details = null;
		entity_id = null;
		id_ = null;
		pdbx_align_begin = null;
		pdbx_db_accession = null;
		pdbx_seq_one_letter_code = null;
		seq_align = null;
		seq_dif = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ref)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ref>\n");
			if (biol_id != null) ow.write(indent + " <PDBx:biol_id>" + biol_id + "</PDBx:biol_id>\n");
			if (db_code != null) ow.write(indent + " <PDBx:db_code>" + db_code + "</PDBx:db_code>\n");
			if (db_name != null) ow.write(indent + " <PDBx:db_name>" + db_name + "</PDBx:db_name>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (entity_id != null) ow.write(indent + " <PDBx:entity_id>" + entity_id + "</PDBx:entity_id>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pdbx_align_begin != null) ow.write(indent + " <PDBx:pdbx_align_begin>" + pdbx_align_begin + "</PDBx:pdbx_align_begin>\n");
			if (pdbx_db_accession != null) ow.write(indent + " <PDBx:pdbx_db_accession>" + pdbx_db_accession + "</PDBx:pdbx_db_accession>\n");
			if (pdbx_seq_one_letter_code != null) ow.write(indent + " <PDBx:pdbx_seq_one_letter_code>" + pdbx_seq_one_letter_code + "</PDBx:pdbx_seq_one_letter_code>\n");
			if (seq_align != null) ow.write(indent + " <PDBx:seq_align>" + seq_align + "</PDBx:seq_align>\n");
			if (seq_dif != null) ow.write(indent + " <PDBx:seq_dif>" + seq_dif + "</PDBx:seq_dif>\n");
			ow.write(indent + "</PDBx:struct_ref>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
