package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_REF_SEQ_DIF category provide a
 *  mechanism for indicating and annotating point differences
 *  between the sequence of the entity or biological unit described
 *  in the data block and the sequence of the referenced database
 *  entry.
 *  
 * <pre>
 *  Example 1 - based on laboratory records for CAP-DNA complex.
 *  <PDBx:struct_ref_seq_difCategory>
 *  <PDBx:struct_ref_seq_dif pdbx_ordinal="1">
 *  <PDBx:align_id>algn2</PDBx:align_id>
 *  <PDBx:seq_num>181</PDBx:seq_num>
 *  <PDBx:db_mon_id>GLU</PDBx:db_mon_id>
 *  <PDBx:mon_id>PHE</PDBx:mon_id>
 *  <PDBx:details> A point mutation was introduced in the CAP at position 181
 *  substituting PHE for GLU.</PDBx:details>
 *  </PDBx:struct_ref_seq_dif>
 *  </PDBx:struct_ref_seq_difCategory>
 * </pre>
 */
public class Struct_ref_seq_dif extends org.pdb.beans.Struct_ref_seq_dif implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_ref_seq_dif";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_ref_seq_dif()
	{
	}

	/** Full constructor */
	public Struct_ref_seq_dif(
		Datablock datablock,
		java.lang.String align_id,
		java.lang.String db_mon_id,
		java.lang.String details,
		java.lang.String mon_id,
		java.lang.String pdbx_auth_seq_num,
		java.lang.Integer pdbx_ordinal,
		java.lang.String pdbx_pdb_id_code,
		java.lang.String pdbx_pdb_ins_code,
		java.lang.String pdbx_pdb_strand_id,
		java.lang.String pdbx_seq_db_accession_code,
		java.lang.String pdbx_seq_db_name,
		java.lang.String pdbx_seq_db_seq_num,
		java.lang.Integer seq_num)
	{
		this.datablock = datablock;
		this.align_id = align_id;
		this.db_mon_id = db_mon_id;
		this.details = details;
		this.mon_id = mon_id;
		this.pdbx_auth_seq_num = pdbx_auth_seq_num;
		this.pdbx_ordinal = pdbx_ordinal;
		this.pdbx_pdb_id_code = pdbx_pdb_id_code;
		this.pdbx_pdb_ins_code = pdbx_pdb_ins_code;
		this.pdbx_pdb_strand_id = pdbx_pdb_strand_id;
		this.pdbx_seq_db_accession_code = pdbx_seq_db_accession_code;
		this.pdbx_seq_db_name = pdbx_seq_db_name;
		this.pdbx_seq_db_seq_num = pdbx_seq_db_seq_num;
		this.seq_num = seq_num;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_ref_seq_dif");
		sb.append("\n");
		if (align_id != null)
		{
			sb.append("align_id = ");
			sb.append(align_id);
			sb.append('\n');
		}
		if (db_mon_id != null)
		{
			sb.append("db_mon_id = ");
			sb.append(db_mon_id);
			sb.append('\n');
		}
		if (details != null)
		{
			sb.append("details = ");
			sb.append(details);
			sb.append('\n');
		}
		if (mon_id != null)
		{
			sb.append("mon_id = ");
			sb.append(mon_id);
			sb.append('\n');
		}
		if (pdbx_auth_seq_num != null)
		{
			sb.append("pdbx_auth_seq_num = ");
			sb.append(pdbx_auth_seq_num);
			sb.append('\n');
		}
		if (pdbx_ordinal != null)
		{
			sb.append("pdbx_ordinal = ");
			sb.append(pdbx_ordinal);
			sb.append('\n');
		}
		if (pdbx_pdb_id_code != null)
		{
			sb.append("pdbx_pdb_id_code = ");
			sb.append(pdbx_pdb_id_code);
			sb.append('\n');
		}
		if (pdbx_pdb_ins_code != null)
		{
			sb.append("pdbx_pdb_ins_code = ");
			sb.append(pdbx_pdb_ins_code);
			sb.append('\n');
		}
		if (pdbx_pdb_strand_id != null)
		{
			sb.append("pdbx_pdb_strand_id = ");
			sb.append(pdbx_pdb_strand_id);
			sb.append('\n');
		}
		if (pdbx_seq_db_accession_code != null)
		{
			sb.append("pdbx_seq_db_accession_code = ");
			sb.append(pdbx_seq_db_accession_code);
			sb.append('\n');
		}
		if (pdbx_seq_db_name != null)
		{
			sb.append("pdbx_seq_db_name = ");
			sb.append(pdbx_seq_db_name);
			sb.append('\n');
		}
		if (pdbx_seq_db_seq_num != null)
		{
			sb.append("pdbx_seq_db_seq_num = ");
			sb.append(pdbx_seq_db_seq_num);
			sb.append('\n');
		}
		if (seq_num != null)
		{
			sb.append("seq_num = ");
			sb.append(seq_num);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		align_id = null;
		db_mon_id = null;
		details = null;
		mon_id = null;
		pdbx_auth_seq_num = null;
		pdbx_ordinal = null;
		pdbx_pdb_id_code = null;
		pdbx_pdb_ins_code = null;
		pdbx_pdb_strand_id = null;
		pdbx_seq_db_accession_code = null;
		pdbx_seq_db_name = null;
		pdbx_seq_db_seq_num = null;
		seq_num = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_ref_seq_dif)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_ref_seq_dif>\n");
			if (align_id != null) ow.write(indent + " <PDBx:align_id>" + align_id + "</PDBx:align_id>\n");
			if (db_mon_id != null) ow.write(indent + " <PDBx:db_mon_id>" + db_mon_id + "</PDBx:db_mon_id>\n");
			if (details != null) ow.write(indent + " <PDBx:details>" + details + "</PDBx:details>\n");
			if (mon_id != null) ow.write(indent + " <PDBx:mon_id>" + mon_id + "</PDBx:mon_id>\n");
			if (pdbx_auth_seq_num != null) ow.write(indent + " <PDBx:pdbx_auth_seq_num>" + pdbx_auth_seq_num + "</PDBx:pdbx_auth_seq_num>\n");
			if (pdbx_ordinal != null) ow.write(indent + " <PDBx:pdbx_ordinal>" + pdbx_ordinal + "</PDBx:pdbx_ordinal>\n");
			if (pdbx_pdb_id_code != null) ow.write(indent + " <PDBx:pdbx_pdb_id_code>" + pdbx_pdb_id_code + "</PDBx:pdbx_pdb_id_code>\n");
			if (pdbx_pdb_ins_code != null) ow.write(indent + " <PDBx:pdbx_pdb_ins_code>" + pdbx_pdb_ins_code + "</PDBx:pdbx_pdb_ins_code>\n");
			if (pdbx_pdb_strand_id != null) ow.write(indent + " <PDBx:pdbx_pdb_strand_id>" + pdbx_pdb_strand_id + "</PDBx:pdbx_pdb_strand_id>\n");
			if (pdbx_seq_db_accession_code != null) ow.write(indent + " <PDBx:pdbx_seq_db_accession_code>" + pdbx_seq_db_accession_code + "</PDBx:pdbx_seq_db_accession_code>\n");
			if (pdbx_seq_db_name != null) ow.write(indent + " <PDBx:pdbx_seq_db_name>" + pdbx_seq_db_name + "</PDBx:pdbx_seq_db_name>\n");
			if (pdbx_seq_db_seq_num != null) ow.write(indent + " <PDBx:pdbx_seq_db_seq_num>" + pdbx_seq_db_seq_num + "</PDBx:pdbx_seq_db_seq_num>\n");
			if (seq_num != null) ow.write(indent + " <PDBx:seq_num>" + seq_num + "</PDBx:seq_num>\n");
			ow.write(indent + "</PDBx:struct_ref_seq_dif>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
