package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SHEET_ORDER category record details
 *  about the order of the residue ranges that form a beta-sheet.
 *  All order links are pairwise and the specified pairs are
 *  assumed to be adjacent to one another in the sheet. These data
 *  items are an alternative to the STRUCT_SHEET_TOPOLOGY data
 *  items and they allow all manner of sheets to be described.
 *  
 * <pre>
 *  Example 1 - simple beta-barrel.
 *  <PDBx:struct_sheet_orderCategory>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_c" range_id_2="strand_d">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_d" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_e" range_id_2="strand_f">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_f" range_id_2="strand_g">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_g" range_id_2="strand_h">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_1" range_id_1="strand_h" range_id_2="strand_a">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  </PDBx:struct_sheet_orderCategory>
 *  
 *  
 *  Example 2 - five stranded mixed-sense sheet with one two-piece strand.
 *  <PDBx:struct_sheet_orderCategory>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_a" range_id_2="strand_b">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_b" range_id_2="strand_c">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d1">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_c" range_id_2="strand_d2">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_d1" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  <PDBx:struct_sheet_order sheet_id="sheet_2" range_id_1="strand_d2" range_id_2="strand_e">
 *  <PDBx:offset>+1</PDBx:offset>
 *  <PDBx:sense>anti-parallel</PDBx:sense>
 *  </PDBx:struct_sheet_order>
 *  </PDBx:struct_sheet_orderCategory>
 * </pre>
 */
public class Struct_sheet_order extends org.pdb.beans.Struct_sheet_order implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_sheet_order";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_sheet_order()
	{
	}

	/** Full constructor */
	public Struct_sheet_order(
		Datablock datablock,
		java.lang.Integer offset,
		java.lang.String range_id_1,
		java.lang.String range_id_2,
		java.lang.String sense,
		java.lang.String sheet_id)
	{
		this.datablock = datablock;
		this.offset = offset;
		this.range_id_1 = range_id_1;
		this.range_id_2 = range_id_2;
		this.sense = sense;
		this.sheet_id = sheet_id;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_sheet_order");
		sb.append("\n");
		if (offset != null)
		{
			sb.append("offset = ");
			sb.append(offset);
			sb.append('\n');
		}
		if (range_id_1 != null)
		{
			sb.append("range_id_1 = ");
			sb.append(range_id_1);
			sb.append('\n');
		}
		if (range_id_2 != null)
		{
			sb.append("range_id_2 = ");
			sb.append(range_id_2);
			sb.append('\n');
		}
		if (sense != null)
		{
			sb.append("sense = ");
			sb.append(sense);
			sb.append('\n');
		}
		if (sheet_id != null)
		{
			sb.append("sheet_id = ");
			sb.append(sheet_id);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		offset = null;
		range_id_1 = null;
		range_id_2 = null;
		sense = null;
		sheet_id = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_sheet_order)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_sheet_order>\n");
			if (offset != null) ow.write(indent + " <PDBx:offset>" + offset + "</PDBx:offset>\n");
			if (range_id_1 != null) ow.write(indent + " <PDBx:range_id_1>" + range_id_1 + "</PDBx:range_id_1>\n");
			if (range_id_2 != null) ow.write(indent + " <PDBx:range_id_2>" + range_id_2 + "</PDBx:range_id_2>\n");
			if (sense != null) ow.write(indent + " <PDBx:sense>" + sense + "</PDBx:sense>\n");
			if (sheet_id != null) ow.write(indent + " <PDBx:sheet_id>" + sheet_id + "</PDBx:sheet_id>\n");
			ow.write(indent + "</PDBx:struct_sheet_order>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
