package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the STRUCT_SITE_KEYWORDS category record
 *  keywords describing the site.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:struct_site_keywordsCategory>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="binding site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="binding pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="P2 site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site C" text="P2 pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="binding site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="binding pocket"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="P2 site"></PDBx:struct_site_keywords>
 *  <PDBx:struct_site_keywords site_id="P2 site D" text="P2 pocket"></PDBx:struct_site_keywords>
 *  </PDBx:struct_site_keywordsCategory>
 * </pre>
 */
public class Struct_site_keywords extends org.pdb.beans.Struct_site_keywords implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "struct_site_keywords";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Struct_site_keywords()
	{
	}

	/** Full constructor */
	public Struct_site_keywords(
		Datablock datablock,
		java.lang.String site_id,
		java.lang.String text)
	{
		this.datablock = datablock;
		this.site_id = site_id;
		this.text = text;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Struct_site_keywords");
		sb.append("\n");
		if (site_id != null)
		{
			sb.append("site_id = ");
			sb.append(site_id);
			sb.append('\n');
		}
		if (text != null)
		{
			sb.append("text = ");
			sb.append(text);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		site_id = null;
		text = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Struct_site_keywords)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:struct_site_keywords>\n");
			if (site_id != null) ow.write(indent + " <PDBx:site_id>" + site_id + "</PDBx:site_id>\n");
			if (text != null) ow.write(indent + " <PDBx:text>" + text + "</PDBx:text>\n");
			ow.write(indent + "</PDBx:struct_site_keywords>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
