package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the SYMMETRY category record details about the
 *  space-group symmetry.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:symmetryCategory>
 *  <PDBx:symmetry entry_id="5HVP">
 *  <PDBx:cell_setting>orthorhombic</PDBx:cell_setting>
 *  <PDBx:Int_Tables_number>18</PDBx:Int_Tables_number>
 *  <PDBx:space_group_name_H-M>P 21 21 2</PDBx:space_group_name_H-M>
 *  </PDBx:symmetry>
 *  </PDBx:symmetryCategory>
 * </pre>
 */
public class Symmetry extends org.pdb.beans.Symmetry implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "symmetry";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Symmetry()
	{
	}

	/** Full constructor */
	public Symmetry(
		Datablock datablock,
		java.lang.Integer Int_Tables_number,
		java.lang.String cell_setting,
		java.lang.String entry_id,
		java.lang.String pdbx_full_space_group_name_H_M,
		java.lang.String space_group_name_H_M,
		java.lang.String space_group_name_Hall)
	{
		this.datablock = datablock;
		this.Int_Tables_number = Int_Tables_number;
		this.cell_setting = cell_setting;
		this.entry_id = entry_id;
		this.pdbx_full_space_group_name_H_M = pdbx_full_space_group_name_H_M;
		this.space_group_name_H_M = space_group_name_H_M;
		this.space_group_name_Hall = space_group_name_Hall;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Symmetry");
		sb.append("\n");
		if (Int_Tables_number != null)
		{
			sb.append("Int_Tables_number = ");
			sb.append(Int_Tables_number);
			sb.append('\n');
		}
		if (cell_setting != null)
		{
			sb.append("cell_setting = ");
			sb.append(cell_setting);
			sb.append('\n');
		}
		if (entry_id != null)
		{
			sb.append("entry_id = ");
			sb.append(entry_id);
			sb.append('\n');
		}
		if (pdbx_full_space_group_name_H_M != null)
		{
			sb.append("pdbx_full_space_group_name_H-M = ");
			sb.append(pdbx_full_space_group_name_H_M);
			sb.append('\n');
		}
		if (space_group_name_H_M != null)
		{
			sb.append("space_group_name_H-M = ");
			sb.append(space_group_name_H_M);
			sb.append('\n');
		}
		if (space_group_name_Hall != null)
		{
			sb.append("space_group_name_Hall = ");
			sb.append(space_group_name_Hall);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		Int_Tables_number = null;
		cell_setting = null;
		entry_id = null;
		pdbx_full_space_group_name_H_M = null;
		space_group_name_H_M = null;
		space_group_name_Hall = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Symmetry)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:symmetry>\n");
			if (Int_Tables_number != null) ow.write(indent + " <PDBx:Int_Tables_number>" + Int_Tables_number + "</PDBx:Int_Tables_number>\n");
			if (cell_setting != null) ow.write(indent + " <PDBx:cell_setting>" + cell_setting + "</PDBx:cell_setting>\n");
			if (entry_id != null) ow.write(indent + " <PDBx:entry_id>" + entry_id + "</PDBx:entry_id>\n");
			if (pdbx_full_space_group_name_H_M != null) ow.write(indent + " <PDBx:pdbx_full_space_group_name_H-M>" + pdbx_full_space_group_name_H_M + "</PDBx:pdbx_full_space_group_name_H-M>\n");
			if (space_group_name_H_M != null) ow.write(indent + " <PDBx:space_group_name_H-M>" + space_group_name_H_M + "</PDBx:space_group_name_H-M>\n");
			if (space_group_name_Hall != null) ow.write(indent + " <PDBx:space_group_name_Hall>" + space_group_name_Hall + "</PDBx:space_group_name_Hall>\n");
			ow.write(indent + "</PDBx:symmetry>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
