package org.pdb.ormapping;

import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 *  Data items in the SYMMETRY_EQUIV category list the
 *  symmetry-equivalent positions for the space group.
 *  
 * <pre>
 *  Example 1 - based on PDB entry 5HVP and laboratory records for the
 *  structure corresponding to PDB entry 5HVP.
 *  <PDBx:symmetry_equivCategory>
 *  <PDBx:symmetry_equiv id="1">
 *  <PDBx:pos_as_xyz>+x,+y,+z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="2">
 *  <PDBx:pos_as_xyz>-x,-y,z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="3">
 *  <PDBx:pos_as_xyz>1/2+x,1/2-y,-z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  <PDBx:symmetry_equiv id="4">
 *  <PDBx:pos_as_xyz>1/2-x,1/2+y,-z</PDBx:pos_as_xyz>
 *  </PDBx:symmetry_equiv>
 *  </PDBx:symmetry_equivCategory>
 * </pre>
 */
public class Symmetry_equiv extends org.pdb.beans.Symmetry_equiv implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean
{
	public static final String tagName = "symmetry_equiv";

	public void addParent(org.pdb.ormapping.util.OrMappingBean parent)
	{
		setDatablock((Datablock)parent);
	}

	/** Object identifier field */
	private Long obj_id;

	public Long getObj_id() 
	{
		return this.obj_id;
	}

	public void setObj_id(Long obj_id) 
	{
		this.obj_id = obj_id;
	}

	/** Default constructor */
	public Symmetry_equiv()
	{
	}

	/** Full constructor */
	public Symmetry_equiv(
		Datablock datablock,
		java.lang.String id_,
		java.lang.String pos_as_xyz)
	{
		this.datablock = datablock;
		this.id_ = id_;
		this.pos_as_xyz = pos_as_xyz;
	}

	protected Datablock datablock;


	public Datablock getDatablock() 
	{
		return datablock;
	}
 
	public void setDatablock(Datablock datablock)
	{
		this.datablock = datablock;
	}

 

	public String toString() 
	{
		StringBuffer sb = new StringBuffer();
		sb.append("Symmetry_equiv");
		sb.append("\n");
		if (id_ != null)
		{
			sb.append("id = ");
			sb.append(id_);
			sb.append('\n');
		}
		if (pos_as_xyz != null)
		{
			sb.append("pos_as_xyz = ");
			sb.append(pos_as_xyz);
			sb.append('\n');
		}
		return sb.toString();
	}

	public void clearValues() 
	{
		obj_id = null;
		id_ = null;
		pos_as_xyz = null;
		
	}

	public boolean equals(Object other) 
	{
		if ( this.obj_id == null ) 
			return super.equals(other);
		return this.obj_id.longValue() == ((Symmetry_equiv)other).obj_id.longValue();
	}

	public int hashCode() 
	{
		return new HashCodeBuilder().append(getObj_id()).toHashCode();
	}

	public void toXml(java.io.OutputStreamWriter ow, String indent)
	{
		try
		{
			ow.write(indent + "<PDBx:symmetry_equiv>\n");
			if (id_ != null) ow.write(indent + " <PDBx:id>" + id_ + "</PDBx:id>\n");
			if (pos_as_xyz != null) ow.write(indent + " <PDBx:pos_as_xyz>" + pos_as_xyz + "</PDBx:pos_as_xyz>\n");
			ow.write(indent + "</PDBx:symmetry_equiv>\n");
		}
		catch (java.io.IOException e)
		{
			e.printStackTrace();
		}
	}
}
