package org.pdb.ormapping.handlers;

public class Chem_comp_atomHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Chem_comp_atom myBean = new org.pdb.ormapping.Chem_comp_atom();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("alt_atom_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAlt_atom_id(fieldValue);
		}
		else if ("atom_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAtom_id(fieldValue);
		}
		else if ("charge".equalsIgnoreCase(fieldName))
		{
			myBean.setCharge( new java.lang.Integer(fieldValue) );
		}
		else if ("comp_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setComp_id(fieldValue);
		}
		else if ("model_Cartn_x".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_x( new java.lang.Float(fieldValue) );
		}
		else if ("model_Cartn_x_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_x_esd( new java.lang.Float(fieldValue) );
		}
		else if ("model_Cartn_y".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_y( new java.lang.Float(fieldValue) );
		}
		else if ("model_Cartn_y_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_y_esd( new java.lang.Float(fieldValue) );
		}
		else if ("model_Cartn_z".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_z( new java.lang.Float(fieldValue) );
		}
		else if ("model_Cartn_z_esd".equalsIgnoreCase(fieldName))
		{
			myBean.setModel_Cartn_z_esd( new java.lang.Float(fieldValue) );
		}
		else if ("partial_charge".equalsIgnoreCase(fieldName))
		{
			myBean.setPartial_charge( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_align".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_align( new java.lang.Integer(fieldValue) );
		}
		else if ("pdbx_alt_atom_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_alt_atom_id(fieldValue);
		}
		else if ("pdbx_alt_comp_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_alt_comp_id(fieldValue);
		}
		else if ("pdbx_aromatic_flag".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_aromatic_flag(fieldValue);
		}
		else if ("pdbx_leaving_atom_flag".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_leaving_atom_flag(fieldValue);
		}
		else if ("pdbx_model_Cartn_x_ideal".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_model_Cartn_x_ideal( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_model_Cartn_y_ideal".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_model_Cartn_y_ideal( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_model_Cartn_z_ideal".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_model_Cartn_z_ideal( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_ordinal".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_ordinal( new java.lang.Integer(fieldValue) );
		}
		else if ("pdbx_stereo_config".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_stereo_config(fieldValue);
		}
		else if ("substruct_code".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSubstruct_code(fieldValue);
		}
		else if ("type_symbol".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setType_symbol(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
