package org.pdb.ormapping.handlers;

public class Database_PDB_revHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Database_PDB_rev myBean = new org.pdb.ormapping.Database_PDB_rev();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("author_name".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setAuthor_name(fieldValue);
		}
		else if ("date".equalsIgnoreCase(fieldName))
		{
			myBean.setDate(org.pdb.ormapping.util.Utils.getCalendar(fieldValue).getTime());
		}
		else if ("date_original".equalsIgnoreCase(fieldName))
		{
			myBean.setDate_original(org.pdb.ormapping.util.Utils.getCalendar(fieldValue).getTime());
		}
		else if ("mod_type".equalsIgnoreCase(fieldName))
		{
			myBean.setMod_type( new java.lang.Integer(fieldValue) );
		}
		else if ("num".equalsIgnoreCase(fieldName))
		{
			myBean.setNum( new java.lang.Integer(fieldValue) );
		}
		else if ("replaced_by".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setReplaced_by(fieldValue);
		}
		else if ("replaces".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setReplaces(fieldValue);
		}
		else if ("status".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setStatus(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
