package org.pdb.ormapping.handlers;

public class Diffrn_detectorHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Diffrn_detector myBean = new org.pdb.ormapping.Diffrn_detector();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("area_resol_mean".equalsIgnoreCase(fieldName))
		{
			myBean.setArea_resol_mean( new java.lang.Float(fieldValue) );
		}
		else if ("details".equalsIgnoreCase(fieldName))
		{
			myBean.setDetails(fieldValue);
		}
		else if ("detector".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setDetector(fieldValue);
		}
		else if ("diffrn_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setDiffrn_id(fieldValue);
		}
		else if ("dtime".equalsIgnoreCase(fieldName))
		{
			myBean.setDtime( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_collection_date".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_collection_date(fieldValue);
		}
		else if ("pdbx_collection_time_total".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_collection_time_total( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_frames_total".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_frames_total( new java.lang.Integer(fieldValue) );
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			myBean.setType(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
