package org.pdb.ormapping.handlers;

public class Em_3d_fittingHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Em_3d_fitting myBean = new org.pdb.ormapping.Em_3d_fitting();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("details".equalsIgnoreCase(fieldName))
		{
			myBean.setDetails(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setId_(fieldValue);
		}
		else if ("method".equalsIgnoreCase(fieldName))
		{
			myBean.setMethod(fieldValue);
		}
		else if ("overall_b_value".equalsIgnoreCase(fieldName))
		{
			myBean.setOverall_b_value( new java.lang.Float(fieldValue) );
		}
		else if ("ref_protocol".equalsIgnoreCase(fieldName))
		{
			myBean.setRef_protocol(fieldValue);
		}
		else if ("ref_space".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setRef_space(fieldValue);
		}
		else if ("software_name".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSoftware_name(fieldValue);
		}
		else if ("target_criteria".equalsIgnoreCase(fieldName))
		{
			myBean.setTarget_criteria(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
