package org.pdb.ormapping.handlers;

public class Entity_polyHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Entity_poly myBean = new org.pdb.ormapping.Entity_poly();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("entity_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setEntity_id(fieldValue);
		}
		else if ("nstd_chirality".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setNstd_chirality(fieldValue);
		}
		else if ("nstd_linkage".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setNstd_linkage(fieldValue);
		}
		else if ("nstd_monomer".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setNstd_monomer(fieldValue);
		}
		else if ("number_of_monomers".equalsIgnoreCase(fieldName))
		{
			myBean.setNumber_of_monomers( new java.lang.Integer(fieldValue) );
		}
		else if ("pdbx_seq_one_letter_code".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_seq_one_letter_code(fieldValue);
		}
		else if ("pdbx_seq_one_letter_code_can".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_seq_one_letter_code_can(fieldValue);
		}
		else if ("pdbx_strand_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_strand_id(fieldValue);
		}
		else if ("pdbx_target_identifier".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_target_identifier(fieldValue);
		}
		else if ("type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 200)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,200);
			}
			myBean.setType(fieldValue);
		}
		else if ("type_details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setType_details(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
