package org.pdb.ormapping.handlers;

public class Phasing_setHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Phasing_set myBean = new org.pdb.ormapping.Phasing_set();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("cell_angle_alpha".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_angle_alpha( new java.lang.Float(fieldValue) );
		}
		else if ("cell_angle_beta".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_angle_beta( new java.lang.Float(fieldValue) );
		}
		else if ("cell_angle_gamma".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_angle_gamma( new java.lang.Float(fieldValue) );
		}
		else if ("cell_length_a".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_length_a( new java.lang.Float(fieldValue) );
		}
		else if ("cell_length_b".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_length_b( new java.lang.Float(fieldValue) );
		}
		else if ("cell_length_c".equalsIgnoreCase(fieldName))
		{
			myBean.setCell_length_c( new java.lang.Float(fieldValue) );
		}
		else if ("detector_specific".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetector_specific(fieldValue);
		}
		else if ("detector_type".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setDetector_type(fieldValue);
		}
		else if ("id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setId_(fieldValue);
		}
		else if ("pdbx_d_res_high".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_d_res_high( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_d_res_low".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_d_res_low( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_temp_details".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_temp_details(fieldValue);
		}
		else if ("radiation_source_specific".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setRadiation_source_specific(fieldValue);
		}
		else if ("radiation_wavelength".equalsIgnoreCase(fieldName))
		{
			myBean.setRadiation_wavelength( new java.lang.Float(fieldValue) );
		}
		else if ("temp".equalsIgnoreCase(fieldName))
		{
			myBean.setTemp( new java.lang.Float(fieldValue) );
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
