package org.pdb.ormapping.handlers;

public class StructHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Struct myBean = new org.pdb.ormapping.Struct();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("pdbx_descriptor".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 1000)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,1000);
			}
			myBean.setPdbx_descriptor(fieldValue);
		}
		else if ("pdbx_formula_weight".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_formula_weight( new java.lang.Float(fieldValue) );
		}
		else if ("pdbx_formula_weight_method".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setPdbx_formula_weight_method(fieldValue);
		}
		else if ("pdbx_model_details".equalsIgnoreCase(fieldName))
		{
			myBean.setPdbx_model_details(fieldValue);
		}
		else if ("title".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 500)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,500);
			}
			myBean.setTitle(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
