package org.pdb.ormapping.handlers;

public class SymmetryHandler implements org.pdb.ormapping.util.BeanHandler
{
	private org.pdb.ormapping.Symmetry myBean = new org.pdb.ormapping.Symmetry();

	public org.pdb.ormapping.util.OrMappingBean getBean()
	{
		return myBean;
	}

	public void reInit()
	{
		myBean.clearValues();
	}

	public void handleLengthViolation(String fieldName, String fieldValue)
	{
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
		System.err.println("Class: " + this.getClass());
		System.err.println("Field: " + fieldName);
		System.err.println("Value: " + fieldValue);
		System.err.println("###########################           DATA LENGTH VIOLATION !!!!!!!          #############################");
	}

	public void setField(String fieldName, String fieldValueIn)
	{
		if (fieldName == null || fieldName.trim().length() < 1) return;
		if (fieldValueIn == null) return;
		String fieldValue = fieldValueIn.trim();
		int fvLen = fieldValue.length();
		if (fvLen < 1) return;
		if ("Int_Tables_number".equalsIgnoreCase(fieldName))
		{
			myBean.setInt_Tables_number( new java.lang.Integer(fieldValue) );
		}
		else if ("cell_setting".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setCell_setting(fieldValue);
		}
		else if ("entry_id".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 10)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,10);
			}
			myBean.setEntry_id(fieldValue);
		}
		else if ("pdbx_full_space_group_name_H-M".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setPdbx_full_space_group_name_H_M(fieldValue);
		}
		else if ("space_group_name_H-M".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 80)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,80);
			}
			myBean.setSpace_group_name_H_M(fieldValue);
		}
		else if ("space_group_name_Hall".equalsIgnoreCase(fieldName))
		{
			if (fvLen > 255)
			{
				handleLengthViolation(fieldName, fieldValue);
				fieldValue = fieldValue.substring(0,255);
			}
			myBean.setSpace_group_name_Hall(fieldValue);
		}
		
	}

	public void addChild(String collectionName, Object aChild)
	{
	}


	public void addChildren(String collectionName, java.util.Set children)
	{
	}
}
