package org.pdb.ormapping.util;

import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 * @author wayne
 * 
 */
public class BeanBuilder
{
   protected static int ixnum = 1;

   protected static String generateSingleTableIndexDDL(Table t)
   {
      if (t.getName().toLowerCase().startsWith("atom_site") || t.getName().toLowerCase().startsWith("geometry")
            || t.getName().toLowerCase().startsWith("resproperties"))
      {
         return "";
      }
      int idxCount = 0;
      StringBuffer sb = new StringBuffer();
      Iterator iter = t.getFields().iterator();
      while (iter.hasNext() && idxCount < 30)
      {
         Field aField = (Field) iter.next();
         String aType = aField.getDataType();
         if (aType.equals("java.lang.String"))
         {
            if (aField.getLength() != null && aField.getLength().intValue() > 200)
            {
               continue;
            }
            StringFieldInfo sfiHelper = new StringFieldInfo();
            StringFieldInfo.SingleFieldInfo sfi = sfiHelper.getFieldInfo(t.getName(), aField.getName());
            if (sfi != null && sfi.getFieldLength() > 200)
            {
               continue;
            }
         }
         // sb.append("drop index iax_");
         // sb.append(ixnum);
         // sb.append(" on ");
         // sb.append(t.getName());
         // sb.append(";\n");
         sb.append("create index iax_");
         sb.append(ixnum++);
         sb.append(" on ");
         sb.append(getSafeFieldName(t.getName()));
         sb.append("(");
         sb.append(getSafeFieldName(aField.getName()));
         sb.append(");\n");
         idxCount++;
      }
      sb.append("\n");
      return sb.toString();
   }

   protected static void generateIndexDDL(Table t)
   {
      File createIndexDDLfile = null;
      Writer createIndexWriter = null;
      try
      {
         createIndexDDLfile = new File("createIdx.sql");
         createIndexWriter = new BufferedWriter(new FileWriter(createIndexDDLfile));
         createIndexWriter.write(generateSingleTableIndexDDL(t));
         Iterator iter = t.getTables().iterator();
         while (iter.hasNext())
         {
            createIndexWriter.write(generateSingleTableIndexDDL((Table) iter.next()));
         }
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
      finally
      {
         if (createIndexWriter != null)
         {
            try
            {
               createIndexWriter.close();
            }
            catch (IOException e1)
            {
               e1.printStackTrace();
            }
         }
      }
   }

   protected static String handlerImportDelclaration = "";

   protected static String handlerClassDelclaration = "\npublic class beanClassHandler implements org.pdb.ormapping.util.BeanHandler\n{\n\t"
         + "private org.pdb.ormapping.beanClass myBean = new org.pdb.ormapping.beanClass();\n\n\t"
         + "public org.pdb.ormapping.util.OrMappingBean getBean()\n\t{\n\t\t"
         + "return myBean;\n\t}\n\n\t"
         + "public void reInit()\n\t{\n\t\tmyBean.clearValues();\n\t}\n";

   // + "public void reInit()\n\t{\n\t\tmyBean = new
   // org.pdb.ormapping.beanClass();\n\t}\n";
   protected static String handlerFieldDelclaration = "\n\tpublic void setField(String fieldName, String fieldValueIn)\n\t{\n\t\t"
         + "if (fieldName == null || fieldName.trim().length() < 1) return;\n\t\t" + "if (fieldValueIn == null) return;\n\t\t"
         + "String fieldValue = fieldValueIn.trim();\n\t\t" + "int fvLen = fieldValue.length();\n\t\t" + "if (fvLen < 1) return;\n\t\t";

   protected static String addChildTemplate = "\n\tpublic void addChild(String collectionName, Object aChild)\n\t{";

   protected static String addChildTemplateCollection = "\n\t\tif (\"childCollectionNames\".equalsIgnoreCase(collectionName))\n\t\t{\n\t\t\t"
         + "java.util.Set aSet = new java.util.HashSet(myBean.getchildCollectionNames());\n\t\t\t"
         + "aSet.add(aChild);\n\t\t\t"
         + "myBean.setchildCollectionNames(aSet);\n\t\t}";

   protected static String addChildrenTemplate = "\n\tpublic void addChildren(String collectionName, java.util.Set children)\n\t{";

   protected static String addChildrenTemplateCollection = "\n\t\tif (\"childCollectionNames\".equalsIgnoreCase(collectionName))\n\t\t{\n\t\t\t"
         + "myBean.setchildCollectionNames(children);\n\t\t}";

   // "if (aSet == null) aSet = new java.util.TreeSet();\n\t\t\t" +

   protected static String handleLengthViolationDelclaration = "\n\tpublic void handleLengthViolation(String fieldName, String fieldValue)"
         + "\n\t{"
         + "\n\t\tSystem.err.println(\"###########################           DATA LENGTH VIOLATION !!!!!!!          #############################\");"
         + "\n\t\tSystem.err.println(\"Class: \" + this.getClass());"
         + "\n\t\tSystem.err.println(\"Field: \" + fieldName);"
         + "\n\t\tSystem.err.println(\"Value: \" + fieldValue);"
         + "\n\t\tSystem.err.println(\"###########################           DATA LENGTH VIOLATION !!!!!!!          #############################\");"
         + "\n\t}\n";

   private static StringFieldInfo sfiHelper = new StringFieldInfo();

   protected static String generateHandler(Table t, Table parentTable)
   {
      StringBuffer sb = new StringBuffer();
      sb.append(packageDelclaration);
      sb.append(".handlers;\n");
      sb.append(handlerImportDelclaration);
      String cd = handlerClassDelclaration;
      String aClassName = Field.toFirstLetterUpper(t.getName());
      sb.append(cd.replaceAll("beanClass", aClassName));
      sb.append(handleLengthViolationDelclaration);
      sb.append(handlerFieldDelclaration);
      Iterator iter = t.getFields().iterator();
      String elseClause = "";
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         StringFieldInfo.SingleFieldInfo sfi = sfiHelper.getFieldInfo(t.getName(), aField.getName());
         boolean needCheck = true;
         int maxLen = 255;
         if (sfi != null)
         {
            maxLen = sfi.getFieldLength();
            if (sfi.getFieldType().equalsIgnoreCase("text")) needCheck = false;
         }
         sb.append(elseClause);
         elseClause = "else ";
         sb.append("if (\"");
         sb.append(aField.getName());
         sb.append("\".equalsIgnoreCase(fieldName))\n\t\t{\n\t\t\t");
         String aType = aField.getDataType();
         if (aType.equals("java.lang.String") && needCheck)
         {
            sb.append("if (fvLen > ");
            sb.append(maxLen);
            sb.append(")\n\t\t\t{\n\t\t\t\t");
            sb.append("handleLengthViolation(fieldName, fieldValue);\n\t\t\t\t");
            sb.append("fieldValue = fieldValue.substring(0,");
            sb.append(maxLen);
            sb.append(");");
            sb.append("\n\t\t\t}\n\t\t\t");
         }
         sb.append("myBean.set");
         sb.append(Field.toFirstLetterUpper(getSafeJavaName(aField.getName())));
         if (aType.equals("java.lang.String"))
         {
            sb.append("(fieldValue);");
         }
         else if (aType.equals("java.util.Calendar"))
         {
            sb.append("(org.pdb.ormapping.util.Utils.getCalendar(fieldValue));");
         }
         else if (aType.equals("java.util.Date"))
         {
            sb.append("(org.pdb.ormapping.util.Utils.getCalendar(fieldValue).getTime());");
         }
         else
         {
            sb.append("( new ");
            sb.append(aType);
            sb.append("(fieldValue) );");
         }
         sb.append("\n\t\t}\n\t\t");
      }
      sb.append("\n\t}\n");

      iter = t.getTables().iterator();
      sb.append(addChildTemplate);
      while (iter.hasNext())
      {
         String fieldName = Field.toFirstLetterUpper(((Table) iter.next()).getName());
         sb.append(addChildTemplateCollection.replaceAll("childCollectionName", fieldName));
      }
      sb.append("\n\t}\n\n");
      iter = t.getTables().iterator();
      sb.append(addChildrenTemplate);
      while (iter.hasNext())
      {
         String fieldName = Field.toFirstLetterUpper(((Table) iter.next()).getName());
         sb.append(addChildrenTemplateCollection.replaceAll("childCollectionName", fieldName));
      }
      sb.append("\n\t}\n");

      sb.append("}\n"); // end of class
      return sb.toString();
   }

   private static long strt = 0;

   private static void beginTiming()
   {
      strt = System.currentTimeMillis();
   }

   private static void doneTiming(String msg)
   {
      float doneTicks = (System.currentTimeMillis() - strt) / 1000F;
      String timemsg = "     * Time to process " + msg + ": " + Float.toString(doneTicks) + " seconds";
      System.err.println(timemsg);
   }

   protected static SortedSet reservedDbWords = null;

   protected static SortedSet reservedJavaWords = null;

   protected static void checkReservedWordsSets()
   {
      if (reservedDbWords == null)
      {
         reservedDbWords = new TreeSet();
         reservedDbWords.add("database");
         reservedDbWords.add("id");

         // this list of reserved words was taken from the derby web site
         // http://db.apache.org/derby/manuals/reference/sqlj150.html
         reservedDbWords.add("add");
         reservedDbWords.add("all");
         reservedDbWords.add("allocate");
         reservedDbWords.add("alter");
         reservedDbWords.add("and");
         reservedDbWords.add("any");
         reservedDbWords.add("are");
         reservedDbWords.add("as");
         reservedDbWords.add("asc");
         reservedDbWords.add("assertion");
         reservedDbWords.add("at");
         reservedDbWords.add("authorization");
         reservedDbWords.add("avg");
         reservedDbWords.add("begin");
         reservedDbWords.add("between");
         reservedDbWords.add("bit");
         reservedDbWords.add("bit_length");
         reservedDbWords.add("boolean");
         reservedDbWords.add("both");
         reservedDbWords.add("by");
         reservedDbWords.add("call");
         reservedDbWords.add("cascade");
         reservedDbWords.add("cascaded");
         reservedDbWords.add("case");
         reservedDbWords.add("cast");
         reservedDbWords.add("char");
         reservedDbWords.add("character");
         reservedDbWords.add("character_length");
         reservedDbWords.add("char_length");
         reservedDbWords.add("check");
         reservedDbWords.add("close");
         reservedDbWords.add("collate");
         reservedDbWords.add("collation");
         reservedDbWords.add("column");
         reservedDbWords.add("commit");
         reservedDbWords.add("connect");
         reservedDbWords.add("connection");
         reservedDbWords.add("constraint");
         reservedDbWords.add("constraints");
         reservedDbWords.add("continue");
         reservedDbWords.add("convert");
         reservedDbWords.add("corresponding");
         reservedDbWords.add("count");
         reservedDbWords.add("create");
         reservedDbWords.add("cross");
         reservedDbWords.add("current");
         reservedDbWords.add("current_date");
         reservedDbWords.add("current_time");
         reservedDbWords.add("current_timestamp");
         reservedDbWords.add("current_user");
         reservedDbWords.add("cursor");
         reservedDbWords.add("deallocate");
         reservedDbWords.add("dec");
         reservedDbWords.add("decimal");
         reservedDbWords.add("declare");
         reservedDbWords.add("deferrable");
         reservedDbWords.add("deferred");
         reservedDbWords.add("delete");
         reservedDbWords.add("desc");
         reservedDbWords.add("describe");
         reservedDbWords.add("diagnostics");
         reservedDbWords.add("disconnect");
         reservedDbWords.add("distinct");
         reservedDbWords.add("double");
         reservedDbWords.add("drop");
         reservedDbWords.add("else");
         reservedDbWords.add("end");
         reservedDbWords.add("endexec");
         reservedDbWords.add("escape");
         reservedDbWords.add("except");
         reservedDbWords.add("exception");
         reservedDbWords.add("exec");
         reservedDbWords.add("execute");
         reservedDbWords.add("exists");
         reservedDbWords.add("explain");
         reservedDbWords.add("external");
         reservedDbWords.add("extract");
         reservedDbWords.add("false");
         reservedDbWords.add("fetch");
         reservedDbWords.add("first");
         reservedDbWords.add("float");
         reservedDbWords.add("for");
         reservedDbWords.add("foreign");
         reservedDbWords.add("found");
         reservedDbWords.add("from");
         reservedDbWords.add("full");
         reservedDbWords.add("function");
         reservedDbWords.add("get");
         reservedDbWords.add("get_current_connection");
         reservedDbWords.add("global");
         reservedDbWords.add("go");
         reservedDbWords.add("goto");
         reservedDbWords.add("grant");
         reservedDbWords.add("group");
         reservedDbWords.add("having");
         reservedDbWords.add("hour");
         reservedDbWords.add("identity");
         reservedDbWords.add("immediate");
         reservedDbWords.add("in");
         reservedDbWords.add("indicator");
         reservedDbWords.add("initially");
         reservedDbWords.add("inner");
         reservedDbWords.add("inout");
         reservedDbWords.add("input");
         reservedDbWords.add("insensitive");
         reservedDbWords.add("insert");
         reservedDbWords.add("int");
         reservedDbWords.add("integer");
         reservedDbWords.add("intersect");
         reservedDbWords.add("into");
         reservedDbWords.add("is");
         reservedDbWords.add("isolation");
         reservedDbWords.add("join");
         reservedDbWords.add("key");
         reservedDbWords.add("last");
         reservedDbWords.add("leading");
         reservedDbWords.add("left");
         reservedDbWords.add("like");
         reservedDbWords.add("local");
         reservedDbWords.add("longint");
         reservedDbWords.add("lower");
         reservedDbWords.add("ltrim");
         reservedDbWords.add("match");
         reservedDbWords.add("max");
         reservedDbWords.add("min");
         reservedDbWords.add("minute");
         reservedDbWords.add("national");
         reservedDbWords.add("natural");
         reservedDbWords.add("nchar");
         reservedDbWords.add("nvarchar");
         reservedDbWords.add("next");
         reservedDbWords.add("no");
         reservedDbWords.add("not");
         reservedDbWords.add("null");
         reservedDbWords.add("nullif");
         reservedDbWords.add("numeric");
         reservedDbWords.add("octet_length");
         reservedDbWords.add("of");
         reservedDbWords.add("on");
         reservedDbWords.add("only");
         reservedDbWords.add("open");
         reservedDbWords.add("option");
         reservedDbWords.add("or");
         reservedDbWords.add("order");
         reservedDbWords.add("out");
         reservedDbWords.add("outer");
         reservedDbWords.add("output");
         reservedDbWords.add("overlaps");
         reservedDbWords.add("pad");
         reservedDbWords.add("partial");
         reservedDbWords.add("prepare");
         reservedDbWords.add("preserve");
         reservedDbWords.add("primary");
         reservedDbWords.add("prior");
         reservedDbWords.add("privileges");
         reservedDbWords.add("procedure");
         reservedDbWords.add("public");
         reservedDbWords.add("read");
         reservedDbWords.add("real");
         reservedDbWords.add("references");
         reservedDbWords.add("relative");
         reservedDbWords.add("restrict");
         reservedDbWords.add("revoke");
         reservedDbWords.add("right");
         reservedDbWords.add("rollback");
         reservedDbWords.add("rows");
         reservedDbWords.add("rtrim");
         reservedDbWords.add("runtimestatistics");
         reservedDbWords.add("schema");
         reservedDbWords.add("scroll");
         reservedDbWords.add("second");
         reservedDbWords.add("select");
         reservedDbWords.add("session_user");
         reservedDbWords.add("set");
         reservedDbWords.add("smallint");
         reservedDbWords.add("some");
         reservedDbWords.add("space");
         reservedDbWords.add("sql");
         reservedDbWords.add("sqlcode");
         reservedDbWords.add("sqlerror");
         reservedDbWords.add("sqlstate");
         reservedDbWords.add("substr");
         reservedDbWords.add("substring");
         reservedDbWords.add("sum");
         reservedDbWords.add("system_user");
         reservedDbWords.add("table");
         reservedDbWords.add("temporary");
         reservedDbWords.add("timezone_hour");
         reservedDbWords.add("timezone_minute");
         reservedDbWords.add("tinyint");
         reservedDbWords.add("to");
         reservedDbWords.add("trailing");
         reservedDbWords.add("transaction");
         reservedDbWords.add("translate");
         reservedDbWords.add("translation");
         reservedDbWords.add("trim");
         reservedDbWords.add("true");
         reservedDbWords.add("union");
         reservedDbWords.add("unique");
         reservedDbWords.add("unknown");
         reservedDbWords.add("update");
         reservedDbWords.add("upper");
         reservedDbWords.add("user");
         reservedDbWords.add("using");
         reservedDbWords.add("values");
         reservedDbWords.add("varchar");
         reservedDbWords.add("varying");
         reservedDbWords.add("view");
         reservedDbWords.add("whenever");
         reservedDbWords.add("where");
         reservedDbWords.add("with");
         reservedDbWords.add("work");
         reservedDbWords.add("write");
         reservedDbWords.add("year");
      }
      if (reservedJavaWords == null)
      {
         reservedJavaWords = new TreeSet();
         reservedJavaWords.add("abstract");
         reservedJavaWords.add("class");
         reservedJavaWords.add("id");
      }
   }

   public static String getShortSafeFieldName(String sIn)
   {
      String s = sIn;
      // super hack to support stupid fricking IBM DB2 limit of 30 chars for column length
      if (s.length() > 30)
      {
         String newGuy = "";
         newGuy = s.substring(0, 13) + s.substring((s.length() - 17), s.length());
         // System.err.println("alter table #### change " + newGuy + " " + s + " @@@@;");
         s = newGuy;
      }
      checkReservedWordsSets();
      if (reservedDbWords.contains(s.toLowerCase()))
      {
         return s + '_';
      }
      if (s.startsWith("_")) s = "a" + s; // fields cant start with a non-letter
      if (s.indexOf('-') >= 0)
      {
         return s.replace('-', '_');
      }
      else if (s.indexOf('/') >= 0)
      {
         return s.replace('/', '_');
      }
      else
      {
         return s;
      }
   }

   public static String getSafeFieldName(String sIn)
   {
      String s = sIn;
      checkReservedWordsSets();
      if (reservedDbWords.contains(s.toLowerCase()))
      {
         return s + '_';
      }
      if (s.startsWith("_")) s = "a" + s; // fields cant start with a non-letter
      if (s.indexOf('-') >= 0)
      {
         return s.replace('-', '_');
      }
      else if (s.indexOf('/') >= 0)
      {
         return s.replace('/', '_');
      }
      else
      {
         return s;
      }
   }

   public static String getSafeJavaName(String s)
   {
      checkReservedWordsSets();
      if (reservedJavaWords.contains(s.toLowerCase()))
      {
         return s + '_';
      }
      else if (s.indexOf('/') >= 0)
      {
         return s.replace('/', '_');
      }
      else
      {
         return s.replaceAll("-", "_");
      }
   }

   protected static String getJavadoc(String s, String indent)
   {
      if (s == null || s.trim().length() == 0) return "";
      s = s.replaceAll("\\*/", "");

      StringBuffer sb = new StringBuffer();
      sb.append("\n");
      sb.append(indent);
      sb.append("/**");
      BufferedReader bsr = new BufferedReader(new StringReader(s));
      boolean preOn = false;
      try
      {
         while (bsr.ready())
         {
            String aLine = bsr.readLine();
            if (aLine != null)
            {
               aLine = aLine.trim();
               if (!preOn && aLine.toLowerCase().startsWith("example"))
               {
                  preOn = true;
                  sb.append("\n");
                  sb.append(indent);
                  sb.append(" * <pre>");
               }
               sb.append("\n");
               sb.append(indent);
               sb.append(" *  ");
               sb.append(aLine);
            }
            else
            {
               break;
            }
         }
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
      if (preOn)
      {
         sb.append("\n");
         sb.append(indent);
         sb.append(" * </pre>");
      }
      sb.append("\n");
      sb.append(indent);
      sb.append(" */");
      return sb.toString();
   }

   protected static String interfaceDelclaration = "\npublic class className \n{\n\t";

   protected static String generateJavaBeanInterface(Table t, Table parentTable)
   {
      StringBuffer sb = new StringBuffer();
      sb.append(packageDelclaration.replaceAll("ormapping", "beans"));
      sb.append(";\n");
      sb.append(getJavadoc(t.getDescription(), ""));
      String cd = interfaceDelclaration;
      String aClassName = Field.toFirstLetterUpper(t.getName());
      sb.append(cd.replaceAll("className", aClassName));

      Iterator iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String dataType = aField.getDataType();
         processField(aField.getName(), dataType, sb, aField.getDescription());
         // processInterfaceField(aField.getName(), dataType, sb,
         // aField.getDescription());
      }
      sb.append("}\n"); // end of interface
      return sb.toString();
   }

   protected static String interfaceGetterDelclaration = "\n\tpublic typeName methodName() ;\n ";

   protected static String interfaceSetterDelclaration = "\n\tpublic void methodName(typeName fieldName) ;\n ";

   protected static void processInterfaceField(String fieldName, String dataType, StringBuffer sb, String doc)
   {
      String safeFieldName = getSafeJavaName(fieldName);
      sb.append(getJavadoc(doc, "\t"));
      String methodName = safeFieldName.substring(0, 1).toUpperCase() + safeFieldName.substring(1);
      String getter = interfaceGetterDelclaration;
      getter = getter.replaceAll("typeName", dataType);
      getter = getter.replaceAll("methodName", "get" + methodName);
      sb.append(getter);
      String setter = interfaceSetterDelclaration;
      setter = setter.replaceAll("typeName", dataType);
      setter = setter.replaceAll("methodName", "set" + methodName);
      setter = setter.replaceAll("fieldName", safeFieldName);
      sb.append(setter);
   }

   protected static String packageDelclaration = "package org.pdb.ormapping";

   protected static String importDelclaration = "\nimport org.apache.commons.lang.builder.HashCodeBuilder;\n";

   protected static String classDelclaration = "\npublic class className extends org.pdb.beans.className implements java.io.Serializable, org.pdb.ormapping.util.OrMappingBean\n{\n\t"
         + "public static final String tagName = \"lowerClassName\";\n";

   protected static String parentSetterTemplate = "\n\tpublic void addParent(org.pdb.ormapping.util.OrMappingBean parent)\n\t{";

   protected static String parentSetterTemplate2 = "\n\t\tsetparentClass((parentClass)parent);";

   protected static String parentSetterTemplate3 = "\n\t}\n";

   protected static String defaultConstuctorTemplate = "\t/** Default constructor */\n\t" + "public className()\n\t{\n\t}\n";

   protected static String fullConstuctorTemplate = "\n\t/** Full constructor */\n\t" + "public className(";

   protected static String identifierFieldTemplate = "\n\t/** Object identifier field */\n\tprivate Long obj_id;\n\n\t"
         + "public Long getObj_id() \n\t{\n\t\t" + "return this.obj_id;\n\t" + "}\n\n\t" + "public void setObj_id(Long obj_id) \n\t{\n\t\t"
         + "this.obj_id = obj_id;\n\t" + "}\n\n";

   protected static String getterDelclaration = "\n\tpublic typeName methodName() \n\t{\n\t\treturn fieldName;\n\t}\n ";

   protected static String setterDelclaration = "\n\tpublic void methodName(typeName fieldName)\n\t{"
         + "\n\t\tthis.fieldName = inputName;\n\t}\n\n ";

   protected static String toStringTemplate = "\n\tpublic String toString() \n\t{\n\t\t" + "StringBuffer sb = new StringBuffer();\n\t\t"
         + "sb.append(\"className\");\n\t\t" + "sb.append(\"\\n\");\n\t\t";

   protected static String clearValuesTemplate = "\n\tpublic void clearValues() \n\t{\n\t\t";

   protected static String toStringFieldTemplate = "if (aSafeField != null)\n\t\t{\n\t\t\t" + "sb.append(\"aField = \");\n\t\t\t"
         + "sb.append(aSafeField);\n\t\t\t" + "sb.append(\'\\n\');\n\t\t}\n\t\t";

   protected static String equalsTemplate = "\n\tpublic boolean equals(Object other) \n\t{\n\t\t"
         + "if ( this.obj_id == null ) \n\t\t\treturn super.equals(other);\n\t\t"
         + "return this.obj_id.longValue() == ((className)other).obj_id.longValue();\n\t}\n";

   protected static String equalsTemplate2 = "\n\tpublic boolean equals(Object other) \n\t{\n\t\t"
         + "if ( this.keyFieldName == null ) return super.equals(other);\n\t\t"
         + "return this.keyFieldName.equals(((className)other).keyFieldName); \n\t}\n";

   protected static String hashTemplate = "\n\tpublic int hashCode() \n\t{\n\t\t"
         + "return new HashCodeBuilder().append(getObj_id()).toHashCode();\n\t}\n";

   protected static String kidObjectTemplate = "//TODO implement one-to-one child object persistence for ";

   protected static String kidCollectionField = "\n\tprivate java.util.Set kidClassSetName = java.util.Collections.EMPTY_SET;\n";

   protected static String kidCollectionTemplate = "\n\tpublic java.util.Set getkidClassNames() \n\t{\n\t\t"
         + "return kidClassSetName;\n\t}\n\n\t" + "public void setkidClassNames(java.util.Set kidClassSetName) \n\t{\n\t\t"
         + "this.kidClassSetName = kidClassSetName;\n\t}\n";

   protected static SortedSet allUsedTypes = new TreeSet();

   protected static String generateJavaBean(Table t, Table parentTable)
   {
      StringBuffer sb = new StringBuffer();
      sb.append(packageDelclaration);
      sb.append(";\n");
      if (t.getKeyField().equalsIgnoreCase("obj_id"))
      {
         sb.append(importDelclaration);
      }
      sb.append(getJavadoc(t.getDescription(), ""));
      String cd = classDelclaration;
      String tn = t.getName();
      cd = cd.replaceAll("tableName", tn);
      String aClassName = Field.toFirstLetterUpper(t.getName());
      String tagName = t.getName();
      cd = cd.replaceAll("lowerClassName", tagName);
      sb.append(cd.replaceAll("className", aClassName));

      sb.append(parentSetterTemplate);
      String parentClassName = null;
      if (parentTable != null)
      {
         parentClassName = Field.toFirstLetterUpper(parentTable.getName());
         sb.append(parentSetterTemplate2.replaceAll("parentClass", parentClassName));
      }
      sb.append(parentSetterTemplate3);

      if (t.getKeyField().equalsIgnoreCase("obj_id"))
      {
         sb.append(identifierFieldTemplate);
      }
      sb.append(defaultConstuctorTemplate.replaceAll("className", aClassName));
      sb.append(fullConstuctorTemplate.replaceAll("className", aClassName));
      String parentField = null;
      if (parentTable != null)
      {
         parentField = getSafeJavaName(parentTable.getName());
      }
      if (parentField != null)
      {
         sb.append("\n\t\t");
         sb.append(Field.toFirstLetterUpper(parentTable.getName()));
         sb.append(' ');
         sb.append(parentField);
         sb.append(',');
      }
      Iterator iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String dataType = aField.getDataType();
         String fieldName = aField.getName();
         sb.append("\n\t\t");
         sb.append(dataType);
         sb.append(' ');
         sb.append(getSafeJavaName(fieldName));
         if (iter.hasNext())
         {
            sb.append(',');
         }
      }
      sb.append(")\n\t{");
      if (parentField != null)
      {
         sb.append("\n\t\tthis.");
         sb.append(parentField);
         sb.append(" = ");
         sb.append(parentField);
         sb.append(';');
      }
      iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String fieldName = getSafeJavaName(aField.getName());
         sb.append("\n\t\tthis.");
         sb.append(fieldName);
         sb.append(" = ");
         if (fieldName.indexOf("seq_one_letter_code") >= 0)
         {
            fieldName = "org.pdb.ormapping.util.Field.removeCrLf(" + fieldName + ")";
         }
         sb.append(fieldName);
         sb.append(";");
      }
      sb.append("\n\t}\n\n");

      if (parentField != null)
      {
         processField(parentTable.getName(), parentClassName, sb, "");
      }

      // dont need to do this since we're extending a bean now, not an
      // interface anymore
      // iter = t.getFields().iterator();
      // while (iter.hasNext())
      // {
      // Field aField = (Field) iter.next();
      // String dataType = aField.getDataType();
      // processField(aField.getName(), dataType, sb,
      // aField.getDescription());
      // }

      iter = t.getTables().iterator();
      while (iter.hasNext())
      {
         String fieldName = ((Table) iter.next()).getName();
         String kidClassName = Field.toFirstLetterUpper(fieldName);
         String kidClassSetName = fieldName.toLowerCase() + "s";
         sb.append(kidCollectionField.replaceAll("kidClassSetName", kidClassSetName));
         String ct = kidCollectionTemplate.replaceAll("kidClassSetName", kidClassSetName);
         ct = ct.replaceAll("kidClassTable", getSafeFieldName(fieldName.toLowerCase()));
         ct = ct.replaceAll("kidClassName", getSafeJavaName(kidClassName));
         sb.append(ct);
      }
      sb.append('\n');

      sb.append(toStringTemplate.replaceAll("className", aClassName));
      iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String fieldName = aField.getName();
         String aft = toStringFieldTemplate.replaceAll("aField", fieldName);
         sb.append(aft.replaceAll("aSafeField", getSafeJavaName(fieldName)));
      }
      sb.append("return sb.toString();\n\t}\n");

      sb.append(clearValuesTemplate);
      sb.append("obj_id = null;\n\t\t");
      iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         sb.append(getSafeJavaName(aField.getName()));
         sb.append(" = null;\n\t\t");
      }
      iter = t.getTables().iterator();
      while (iter.hasNext())
      {
         String fieldName = ((Table) iter.next()).getName();
         String kidClassSetName = fieldName.toLowerCase() + "s";
         sb.append(kidClassSetName);
         sb.append(" = null;\n\t\t");
      }
      sb.append("\n\t}\n");

      if (t.getKeyField().equalsIgnoreCase("obj_id"))
      {
         sb.append(equalsTemplate.replaceAll("className", aClassName));
         sb.append(hashTemplate);
      }
      else
      {
         sb.append(equalsTemplate2.replaceAll("className", aClassName).replaceAll("keyFieldName", getSafeJavaName(t.getKeyField())));
      }

      // generate toXml method
      if (t.getTables().size() > 0)
      {
         sb.append(toXmlTemplate.replaceAll("tagName", tagName));
      }
      else
      {
         sb.append(toXmlTemplateNoKids.replaceAll("tagName", tagName));
      }
      if (aClassName.equalsIgnoreCase("datablock"))
      {
         sb.append("\\n            xmlns:PDBx=\\\"http://deposit.pdb.org/pdbML/pdbx-v1.000.xsd\\\"\\n            "
               + "xmlns:xsi=\\\"http://www.w3.org/2001/XMLSchema-instance\\\"\\n            "
               + "xsi:schemaLocation=\\\"http://deposit.pdb.org/pdbML/pdbx-v1.000.xsd pdbx-v1.000.xsd\\\"");
      }
      sb.append(toXmlTemplate2);
      iter = t.getFields().iterator();
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String fieldName = aField.getName();
         String xft = toXmlFieldTemplate.replaceAll("aField", fieldName);
         sb.append(xft.replaceAll("aSafeField", getSafeJavaName(fieldName)));
      }

      iter = t.getTables().iterator();
      if (iter.hasNext())
      {
         sb.append("java.util.Iterator setIterator = null;\n\t\t\t");
      }
      while (iter.hasNext())
      {
         String fieldName = ((Table) iter.next()).getName();
         String kidClassSetName = fieldName.toLowerCase() + "s";
         sb.append("setIterator = ");
         sb.append(kidClassSetName);
         sb.append(toXmlCollectionFieldTemplate.replaceAll("tagName", Introspector.decapitalize(fieldName)));
      }
      sb.append(toXmlTemplateEnd.replaceAll("tagName", tagName));

      sb.append("}\n"); // end of class
      return sb.toString();
   }

   protected static String toXmlTemplate = "\n\tpublic void toXml(java.io.OutputStreamWriter ow, String indent)\n\t{\n\t\t"
         + "org.pdb.ormapping.util.OrMappingBean aBean = null;\n\t\t" + "boolean doCat = false;\n\t\t" + "try\n\t\t{\n\t\t\t"
         + "ow.write(indent + \"<PDBx:tagName";

   protected static String toXmlTemplateNoKids = "\n\tpublic void toXml(java.io.OutputStreamWriter ow, String indent)\n\t{\n\t\t"
         + "try\n\t\t{\n\t\t\t" + "ow.write(indent + \"<PDBx:tagName";

   protected static String toXmlTemplate2 = ">\\n\");\n\t\t\t";

   protected static String toXmlCollectionFieldTemplate = ".iterator();\n\t\t\tif (setIterator.hasNext())\n\t\t\t{\n\t\t\t\t"
         + "ow.write(indent + \" <PDBx:tagNameCategory>\");\n\t\t\t}" + "\n\t\t\twhile(setIterator.hasNext())\n\t\t\t{\n\t\t\t\t"
         + "aBean = (org.pdb.ormapping.util.OrMappingBean)setIterator.next();\n\t\t\t\t"
         + "aBean.toXml(ow, indent + \" \");\n\t\t\t}\n\t\t\t"
         + "if (doCat)\n\t\t\t{\n\t\t\t\tow.write(indent + \" </PDBx:tagNameCategory>\");\n\t\t\t}\n\t\t\t";

   protected static String toXmlFieldTemplate = "if (aSafeField != null) ow.write(indent + \" <PDBx:aField>\" + aSafeField + \"</PDBx:aField>\\n\");\n\t\t\t";

   protected static String toXmlTemplateEnd = "ow.write(indent + \"</PDBx:tagName>\\n\");\n\t\t}\n\t\tcatch (java.io.IOException e)\n\t\t{\n\t\t\te.printStackTrace();\n\t\t}\n\t}\n";

   protected static void processField(String fieldName, String dataType, StringBuffer sb, String doc)
   {
      String safeFieldName = getSafeJavaName(fieldName);
      sb.append("\tprotected ");
      if (!dataType.toLowerCase().startsWith("org.pdb"))
      {
         allUsedTypes.add(dataType);
      }
      sb.append(dataType);
      sb.append(" ");
      sb.append(safeFieldName);
      sb.append(";\n\n");
      sb.append(getJavadoc(doc, "\t"));
      String methodName = safeFieldName.substring(0, 1).toUpperCase() + safeFieldName.substring(1);
      String getter = getterDelclaration;
      getter = getter.replaceAll("fieldName", safeFieldName);
      getter = getter.replaceAll("typeName", dataType);
      getter = getter.replaceAll("methodName", "get" + methodName);
      sb.append(getter);
      String setter = setterDelclaration;
      setter = setter.replaceAll("typeName", dataType);
      setter = setter.replaceAll("methodName", "set" + methodName);
      setter = setter.replaceAll("fieldName", safeFieldName);
      if (safeFieldName.indexOf("seq_one_letter_code") >= 0)
      {
         safeFieldName = "org.pdb.ormapping.util.Field.removeCrLf(" + safeFieldName + ")";
      }
      setter = setter.replaceAll("inputName", safeFieldName);
      sb.append(setter);
   }

   public static String mapHead = "<?xml version=\"1.0\"?>\n\n" + "<!DOCTYPE hibernate-mapping PUBLIC\n\t"
         + "\"-//Hibernate/Hibernate Mapping DTD//EN\"\n\t" + "\"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n\n"
         + "<hibernate-mapping>\n\n\t";

   public static String mapClass = "\n\t<class name=\"org.pdb.ormapping.className\" proxy=\"org.pdb.ormapping.className\" table=\"tableName\"> \n\t\t";

   public static String mapId = "<id name=\"obj_id\" column=\"obj_id\" type=\"long\">\n\t\t\t" + "<generator class=\"increment\" />\n\t\t"
         + "</id>";

   public static String mapId2 = "<id name=\"keyFieldName\" column=\"keyFieldName\">\n\t\t\t" + "<generator class=\"assigned\" />\n\t\t"
         + "</id>";

   public static String mapProp = "<property name=\"javaName\" type=\"dataType\" lengthInfo column=\"fieldName\" />";

   public static String mapOneToOne = "<!-- need to do one-to-one for objName  -->";

   public static String mapOneToMany = "\n\t\t<set name=\"kidClassSetName\" table=\"kidClassTable\" inverse=\"true\" cascade=\"all\" lazy=\"true\">\n\t\t\t"
         + "<key column=\"parent_obj_id\" />\n\t\t\t<one-to-many class=\"org.pdb.ormapping.className\" />\n\t\t</set>";

   public static String mapManyToOne = "\n\t\t<many-to-one name=\"parentClassTable\" class=\"org.pdb.ormapping.parentClassName\" column=\"parent_obj_id\" not-null=\"true\" />";

   protected static String generateMapping(Table t, Table parentTable)
   {
      StringFieldInfo sfiHelper = new StringFieldInfo();
      StringBuffer sb = new StringBuffer();
      String mc = mapClass;
      String tn = getSafeFieldName(t.getName());
      mc = mc.replaceAll("tableName", tn.toLowerCase());
      String aClassName = Field.toFirstLetterUpper(t.getName());
      sb.append(mc.replaceAll("className", aClassName));
      if (t.getKeyField().equalsIgnoreCase("obj_id"))
      {
         sb.append(mapId);
      }
      else
      {
         String javaName = getSafeJavaName(Introspector.decapitalize(t.getKeyField()));
         if (javaName.length() > 1 && Character.isUpperCase(javaName.charAt(1)))
         {
            javaName = Field.toFirstLetterUpper(javaName);
         }
         String mid = mapId2.replaceAll("keyFieldName", javaName);
         sb.append(mid);
      }
      Iterator iter = t.getFields().iterator();
      Collection sfiTypes = new ArrayList();
      boolean badbuild = false;
      while (iter.hasNext())
      {
         Field aField = (Field) iter.next();
         String dataType = aField.getDataType();
         String fieldName = getSafeFieldName(aField.getName()).toLowerCase();
         String javaName = getSafeJavaName(Introspector.decapitalize(aField.getName()));
         if (javaName.length() > 1 && Character.isUpperCase(javaName.charAt(1)))
         {
            javaName = Field.toFirstLetterUpper(javaName);
         }
         String mp = mapProp;
         mp = mp.replaceAll("fieldName", fieldName);
         mp = mp.replaceAll("javaName", javaName);
         StringFieldInfo.SingleFieldInfo sfi = sfiHelper.getFieldInfo(tn, fieldName);
         if (sfi != null)
         {
            if (!dataType.equalsIgnoreCase("java.lang.String"))
            {
               System.err.println("better fix field " + aField.getName() + " in " + t.getName());
               badbuild = true;
            }
            sfiTypes.add(dataType);
            int fieldLen = sfi.getFieldLength();
            if (sfi.getFieldType().equalsIgnoreCase("text"))
            {
               mp = mp.replaceAll("lengthInfo", "length=\"16000000\"");
               mp = mp.replaceAll("dataType", "java.lang.String");
            }
            else if (fieldLen > 255)
            {
               mp = mp.replaceAll("lengthInfo", "length=\"" + Integer.toString(sfi.getFieldLength()) + "\"");
               mp = mp.replaceAll("dataType", "java.lang.String");
            }
            else
            {
               mp = mp.replaceAll("lengthInfo", "length=\"" + Integer.toString(sfi.getFieldLength()) + "\"");
               mp = mp.replaceAll("dataType", "java.lang.String");
            }
         }
         else if (dataType.equals("java.util.Date"))
         {
            mp = mp.replaceAll("lengthInfo", "");
            mp = mp.replaceAll("dataType", "date");
         }
         else if (dataType.equals("java.util.Calendar"))
         {
            mp = mp.replaceAll("lengthInfo", "");
            mp = mp.replaceAll("dataType", "calendar");
         }
         else
         {
            mp = mp.replaceAll("lengthInfo", "");
            mp = mp.replaceAll("dataType", dataType);
         }
         sb.append("\n\t\t");
         sb.append(mp);
      }

      //iter = sfiTypes.iterator();
      //while (iter.hasNext())
      //{
      //   System.out.println(iter.next());
      //}
      if (badbuild)
      {
         throw new RuntimeException("crap - bad data types");
      }
      iter = t.getTables().iterator();
      while (iter.hasNext())
      {
         String fieldName = ((Table) iter.next()).getName();
         String kidClassName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
         String kidTableName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
         String kidClassSetName = Introspector.decapitalize(kidClassName) + "s";
         String ct = mapOneToMany.replaceAll("kidClassSetName", kidClassSetName);
         ct = ct.replaceAll("kidClassTable", getSafeFieldName(kidTableName).toLowerCase());
         ct = ct.replaceAll("className", kidClassName);
         sb.append(ct);
      }

      if (parentTable != null)
      {
         String ptn = parentTable.getName();
         String pClassName = Field.toFirstLetterUpper(ptn);
         String mto = mapManyToOne.replaceAll("parentClassTable", ptn.toLowerCase());
         mto = mto.replaceAll("parentClassName", pClassName);
         sb.append(mto);
         if (!pClassName.equalsIgnoreCase("datablock"))
         {
            System.err.println("Interesting - parent class is " + pClassName);
         }
      }

      sb.append("\n\t</class>\n"); // end of class
      saveHbm(sb.toString(), codeOutputDir, aClassName);
      return sb.toString();
   }

   protected static StringBuffer hibernateMap = new StringBuffer();

   protected static void processTable(Table t, Table parentTable)
   {
      // System.err.println(t.toString());
      String className = Field.toFirstLetterUpper(t.getName());

      Iterator it = t.getTables().iterator();
      while (it.hasNext())
      {
         Table kid = (Table) it.next();
         processTable(kid, t);
      }
      String beanInterfaceCode = generateJavaBeanInterface(t, parentTable);
      String beanCode = generateJavaBean(t, parentTable);
      String handlerCode = generateHandler(t, parentTable);
      try
      {
         String aFileName = codeOutputDir + java.io.File.separator + "handlers" + java.io.File.separator + className + "Handler.java";
         Writer w = new BufferedWriter(new FileWriter(interfaceOutputDir + java.io.File.separator + className + ".java"));
         w.write(beanInterfaceCode);
         w.close();
         w = new BufferedWriter(new FileWriter(codeOutputDir + java.io.File.separator + className + ".java"));
         w.write(beanCode);
         w.close();
         w = new BufferedWriter(new FileWriter(aFileName));
         w.write(handlerCode);
         w.close();
         w = null;
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
      String mapCode = generateMapping(t, parentTable);
      hibernateMap.append(mapCode);
   }

   protected static String partialOutputDir = "org" + File.separator + "pdb";

   protected static String codeOutputDir = partialOutputDir + File.separator + "ormapping";

   protected static String interfaceOutputDir = partialOutputDir + File.separator + "beans";

   protected static String outputPath = "." + File.separator;

   public static void generateJavaBeans(Table t, File outputDir)
   {
      try
      {
         outputPath = outputDir.getCanonicalPath();
         codeOutputDir = outputPath + java.io.File.separator + codeOutputDir;
      }
      catch (IOException e1)
      {
         e1.printStackTrace();
      }
      System.err.println("Using output directory: " + outputPath);
      beginTiming();
      processTable(t, null);
      // saveHbm(hibernateMap.toString(), outputPath,
      // "hibernate-mapping.xml");

      System.err.println("\n\nData Types Used in Mapping Classes:\n--------------------------------");
      Iterator iter = allUsedTypes.iterator();
      while (iter.hasNext())
      {
         System.err.println(iter.next());
      }
      doneTiming("generateJavaBeans()");
      generateIndexDDL(t);
   }

   public static void saveHbm(String mapping, String mappingDir, String mappingName)
   {
      // System.err.println("HBM " + mappingName + " using output directory: "
      // + mappingDir);
      StringBuffer sb = new StringBuffer();
      sb.append(mapHead);
      sb.append(mapping);
      sb.append("\n</hibernate-mapping>\n");
      if (mappingName != null && !mappingName.endsWith("xml"))
      {
         mappingName = mappingName + ".hbm.xml";
      }
      try
      {
         Writer w = new BufferedWriter(new FileWriter(mappingDir + java.io.File.separator + mappingName));
         w.write(sb.toString());
         w.close();
         w = null;
      }
      catch (IOException e)
      {
         e.printStackTrace();
      }
   }

}