package org.pdb.ormapping.util;


public class Field implements Comparable {
	private Table parent = null;

	private String name = null;

	private String description = null;

	private String dataType = null;

	private Integer order = null;

	private Integer length = null;

	private String minValue = null;
	private String maxValue = null;
	private String units = null;
	private boolean isNullable = false;
	private CifEnum enumValues = null;

	private boolean isAttribute = false; // used to regenerate XML

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object obj) {
		if (!(obj instanceof Field)) return -1;
		Field other = (Field)obj;
		return this.name.compareTo(other.name);
	}

	public String toString() {
		return toStringIndent("");
	}
	public String toStringIndent(String indent) {
		StringBuffer sb = new StringBuffer();
		sb.append('\n');
		sb.append(indent);
		sb.append("Field Name: ");
		sb.append(this.name);
		if (parent != null) {
			sb.append("  (Parent Table = ");
			sb.append(parent.getName());
			sb.append(")");
		}
		if (dataType != null) {
			sb.append('\n');
			sb.append(indent);
			sb.append("Data Type = ");
			sb.append(dataType);
		}
		if (description != null) {
			sb.append('\n');
			sb.append(indent);
			sb.append("Description:");
			sb.append('\n');
			sb.append(indent);
			sb.append(
				"------------------------------------------------------------------------------------");
			sb.append('\n');
			sb.append(indent);
			sb.append(this.description);
			sb.append('\n');
			sb.append(indent);
			sb.append(
				"------------------------------------------------------------------------------------");
		}
		return sb.toString();
	}

	/**
	 * 
	 */
	public Field(Table parent, boolean isAttribute) {
		super();
		this.parent = parent;
		this.isAttribute = isAttribute;
	}

	/**
	 * @return
	 */
	public String getDataType() {
		return dataType;
	}

	/**
	 * @param dataType
	 */
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return
	 */
	public Integer getLength() {
		return length;
	}

	/**
	 * @param length
	 */
	public void setLength(Integer length) {
		this.length = length;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return
	 */
	public Integer getOrder() {
		return order;
	}

	/**
	 * @param order
	 */
	public void setOrder(Integer order) {
		this.order = order;
	}
	
	/**
	 * remove cr and lf
	 */
	public static String removeCrLf(String s)
	{
		if (s == null || s.trim().length() == 0)
		{
			return "";
		}
		char[] a = s.toCharArray();
		char[] b = new char[a.length];
		int outpos = 0;
		int curpos = 0;
		while (curpos < a.length)
		{
			if (a[curpos] == '\n' || a[curpos] == '\r' || a[curpos] == '\t' || a[curpos] == ' ')
			{
				curpos++;
				continue;
			}
			b[outpos++] = a[curpos++];
		}
		if (outpos > 0)
		{
			return new String(b, 0, outpos);
		}
		else
		{
			return "";
		}
	}

	public static String toFirstLetterUpper(String s)
	{
		return s.substring(0, 1).toUpperCase() + s.substring(1);
	}

	/**
	 * @return
	 */
	public boolean isNullable()
	{
		return isNullable;
	}

	/**
	 * @param isNullable
	 */
	public void setIsNullable(boolean isNullable)
	{
		this.isNullable = isNullable;
	}

	/**
	 * @return
	 */
	public String getMaxValue()
	{
		return maxValue;
	}

	/**
	 * @param maxValue
	 */
	public void setMaxValue(String maxValue)
	{
		this.maxValue = maxValue;
	}

	/**
	 * @return
	 */
	public String getMinValue()
	{
		return minValue;
	}

	/**
	 * @param minValue
	 */
	public void setMinValue(String minValue)
	{
		this.minValue = minValue;
	}

	/**
	 * @return
	 */
	public String getUnits()
	{
		return units;
	}

	/**
	 * @param units
	 */
	public void setUnits(String units)
	{
		this.units = units;
	}

	/**
	 * @return
	 */
	public Table getParent()
	{
		return parent;
	}

	/**
	 * @return
	 */
	public CifEnum getEnumValues()
	{
		return enumValues;
	}

	/**
	 * @param enumValues
	 */
	public void setEnumValues(CifEnum enumValues)
	{
		this.enumValues = enumValues;
	}

}
