package org.pdb.ormapping.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;

/**
 * @author wayne
 * 
 */
public class HibernateUtils
{

   // ------------------------------------------------
   // configuration and session factory stuff
   // ------------------------------------------------

   protected static SessionFactory factory = null;

   protected static SessionFactory mypdbfactory = null;

   protected static Configuration cfg = null;

   protected static Configuration mypdbcfg = null;

   public synchronized static Configuration getConfiguration()
   {
      if (cfg == null)
      {
         init();
      }
      return cfg;
   }

   public synchronized static Configuration getMyPdbConfiguration()
   {
      if (mypdbcfg == null)
      {
         initMyPdb();
      }
      return mypdbcfg;
   }

   public synchronized static SessionFactory getSessionFactory()
   {
      if (factory == null)
      {
         // first check if we're running inside jboss
         SessionFactory aSessFactory = getSessionFactoryFromContext();
         if (aSessFactory != null)
         {
            factory = aSessFactory;
         }
         else
         {
            // ok, not inside jboss so
            init();
         }
      }
      return factory;
   }

   public static SessionFactory getSessionFactoryFromContext()
   {
      SessionFactory ans = null;
      try
      {
         Hashtable envTable = new Hashtable();
         envTable.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
         envTable.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
         envTable.put("java.naming.provider.url", "localhost");
         InitialContext ic = new InitialContext(); // add param envTable to do out-of-JBoss connection
         ans = (SessionFactory) PortableRemoteObject.narrow(ic.lookup("java:/hibernate/PdbFactory"), SessionFactory.class);
         System.err.println("Got pdbFactory from context");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   public static void init()
   {
      System.err.println("\n" + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "                 HibernateUtils init building Configuration and SessionFactory                \n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n"
            + "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@\n");
      BufferedReader ris = null;
      String aLine = null;
      try
      {
         cfg = new Configuration();
         ris = new BufferedReader(new InputStreamReader(HibernateUtils.class.getResourceAsStream("/org/pdb/ormapping/hbmlist.txt")));
         if (ris != null)
         {
            while (ris.ready())
            {
               aLine = ris.readLine();
               System.err.println(aLine);
               cfg.addResource(aLine);
            }
            ris.close();
            ris = null;
         }

         try
         {
            factory = cfg.configure().buildSessionFactory();
         }
         catch (Throwable e)
         {
            e.printStackTrace();
            // hmmm, no config file in the classpath, lets use the defaults since they must be doing development
            addDefaultConfigStuff(cfg);
            factory = cfg.buildSessionFactory();
         }
      }
      catch (Exception e)
      {
         if (ris != null)
         {
            try
            {
               ris.close();
            }
            catch (IOException ioe)
            {
            }
         }
         e.printStackTrace();
         System.err.println("error configuring");
         throw new RuntimeException(e.getMessage());
      }
   }

   public static void addDefaultConfigStuff(Configuration cfg)
   {
      cfg.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
      cfg.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
      cfg.setProperty("hibernate.connection.username", "pdbdata2");
      cfg.setProperty("hibernate.connection.password", "lom5ong0");
      cfg.setProperty("hibernate.connection.url",
            "jdbc:mysql://developer.rcsb.org:8888/pdb2004?autoReconnect=true&max_allowed_packet=2048000");
      cfg.setProperty("hibernate.show_sql", "true");
      cfg.setProperty("hibernate.use_outer_join", "true");
      cfg.setProperty("hibernate.jdbc.batch_size", "500");
      cfg.setProperty("hibernate.connection.isolation", "2"); // TRANSACTION_READ_COMMITTED
      cfg.setProperty("hibernate.c3p0.min_size", "5");
      cfg.setProperty("hibernate.c3p0.max_size", "25");
      cfg.setProperty("hibernate.c3p0.timeout", "1800");
      cfg.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
      cfg.setProperty("hibernate.cache.use_query_cache", "false");
      cfg.setProperty("hibernate.cache.use_minimal_puts", "false");
      cfg.setProperty("hibernate.max_fetch_depth", "3");
   }

   public void destroy()
   {
      try
      {
         factory.close();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.err.println("error closing");
      }
      try
      {
         mypdbfactory.close();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.err.println("error closing");
      }
   }

   public String getDialect()
   {
      return Environment.getProperties().getProperty(Environment.DIALECT);
   }

   // ////////////////////////////////////////////////
   // My PDB Stuff //////////////////////////////////
   // ////////////////////////////////////////////////

   public static void addDefaultMyPdbConfigStuff(Configuration cfg)
   {
      cfg.setProperty("hibernate.dialect", "org.hibernate.dialect.MySQLInnoDBDialect");
      cfg.setProperty("hibernate.connection.driver_class", "com.mysql.jdbc.Driver");
      cfg.setProperty("hibernate.connection.username", "pdbdata2");
      cfg.setProperty("hibernate.connection.password", "lom5ong0");
      cfg.setProperty("hibernate.connection.url", "jdbc:mysql://core1.rcsb.org:8888/forums?autoReconnect=true&max_allowed_packet=2048000");
      cfg.setProperty("hibernate.show_sql", "true");
      cfg.setProperty("hibernate.use_outer_join", "true");
      cfg.setProperty("hibernate.jdbc.batch_size", "500");
      cfg.setProperty("hibernate.connection.isolation", "2"); // TRANSACTION_READ_COMMITTED
      cfg.setProperty("hibernate.c3p0.min_size", "5");
      cfg.setProperty("hibernate.c3p0.max_size", "25");
      cfg.setProperty("hibernate.c3p0.timeout", "1800");
      cfg.setProperty("hibernate.cache.provider_class", "org.hibernate.cache.NoCacheProvider");
      cfg.setProperty("hibernate.cache.use_query_cache", "false");
      cfg.setProperty("hibernate.cache.use_minimal_puts", "false");
      cfg.setProperty("hibernate.max_fetch_depth", "3");
   }

   public static void initMyPdb()
   {
      System.err.println("\n" + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "                 HibernateUtils MyPDB init building Configuration and SessionFactory          \n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n"
            + "##############################################################################################\n");
      BufferedReader ris = null;
      try
      {
         mypdbcfg = new Configuration();
         mypdbcfg.addResource("org/pdb/mypdb/Query.hbm.xml");
         mypdbcfg.addResource("org/pdb/mypdb/User.hbm.xml");
         mypdbcfg.addResource("org/pdb/mypdb/UserRol.hbm.xml");
         mypdbcfg.addResource("org/pdb/mypdb/UserRolJnc.hbm.xml");

         try
         {
            mypdbfactory = mypdbcfg.configure("mypdbhibernate.cfg.xml").buildSessionFactory();
         }
         catch (Throwable e)
         {
            e.printStackTrace();
            // hmmm, no config file in the classpath, lets use the defaults since they must be doing development
            addDefaultConfigStuff(mypdbcfg);
            mypdbfactory = mypdbcfg.buildSessionFactory();
         }
      }
      catch (Exception e)
      {
         if (ris != null)
         {
            try
            {
               ris.close();
            }
            catch (IOException ioe)
            {
            }
         }
         e.printStackTrace();
         System.err.println("error configuring mypdb");
         throw new RuntimeException(e.getMessage());
      }
   }

   public synchronized static SessionFactory getMyPdbSessionFactory()
   {
      if (mypdbfactory == null)
      {
         // first check if we're running inside jboss
         SessionFactory aSessFactory = getMypdbSessionFactoryFromContext();
         if (aSessFactory != null)
         {
            mypdbfactory = aSessFactory;
         }
         else
         {
            System.err.println("Doh, mypdb doesnt have an init for outside jboss yet!");
            // ok, not inside jboss so
            initMyPdb();
         }
      }
      return mypdbfactory;
   }

   public static SessionFactory getMypdbSessionFactoryFromContext()
   {
      SessionFactory ans = null;
      try
      {
         Hashtable envTable = new Hashtable();
         envTable.put("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
         envTable.put("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
         envTable.put("java.naming.provider.url", "localhost");
         InitialContext ic = new InitialContext(); // add param envTable to do out-of-JBoss connection
         ans = (SessionFactory) PortableRemoteObject.narrow(ic.lookup("java:/hibernate/myPdbFactory"), SessionFactory.class);
         System.err.println("Got myPdbFactory from context");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   public static Session getMyPdbSession() throws HibernateException
   {
      Session ans = null;
      try
      {
         ans = HibernateUtils.getMyPdbSessionFactory().openSession();
         ans.connection().setAutoCommit(false);
         if (needMyPdbCatalogCheck)
         {
            HibernateUtils.checkMyPdbCatalog();
         }
      }
      catch (SQLException e)
      {
         e.printStackTrace();
         throw new HibernateException(e);
      }
      return ans;
   }

   public static StatelessSession getMyPdbStatelessSession()
   {
      StatelessSession ans = null;
      try
      {
         ans = HibernateUtils.getMyPdbSessionFactory().openStatelessSession();
         ans.connection().setAutoCommit(false);
         HibernateUtils.checkMyPdbCatalog();
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   protected static boolean needMyPdbCatalogCheck = true;

   public static void checkMyPdbCatalog()
   {
      needMyPdbCatalogCheck = false;
      Session sess = HibernateUtils.getMyPdbSessionFactory().openSession();
      try
      {
         sess.connection().setAutoCommit(false);
         sess.connection().setCatalog("forums");
      }
      catch (Exception e1)
      {
         e1.printStackTrace();
         try
         {
            sess.connection().setCatalog("forums");
         }
         catch (Exception e2)
         {
            System.err.println("failed during second try - setCatalog forums");
            e2.printStackTrace();
         }
      }
      finally
      {
         if (sess != null)
         {
            sess.close();
         }
      }
   }

   // /////////////////////////////////
   // //////////////////////////////////
   // /////////////////////////////////////

   // ------------------------------------------------------------------
   // older sess factory stuff - legacy methods in here
   // ------------------------------------------------------------------

   public static Configuration getNewConfig()
   {
      return getConfiguration();
   }

   public static Configuration getHibernateConfig()
   {
      return getConfiguration();
   }

   // ------------------------------------------------
   // clean up methods
   // ------------------------------------------------
   /**
    * clean up a session
    */
   public static void HandleHibernateException(Session s, Throwable th)
   {
      HandleHibernateException(s, th, false);
   }

   // ------------------------------------------------
   // clean up methods
   // ------------------------------------------------
   /**
    * clean up a session
    */
   public static void HandleHibernateException(Session s, Throwable th, boolean silently)
   {
      if (!silently)
      {
         System.err.println("-------------------------------- HandleHibernateException --------------------------------");
         th.printStackTrace();
      }
      if (s != null)
      {
         try
         {
            s.connection().rollback();
         }
         catch (Exception anye)
         {
            if (!silently)
            {
               System.err.println("------ exception during rollback -------");
               anye.printStackTrace();
            }
         }
         try
         {
            s.close();
         }
         catch (Exception anye)
         {
            if (!silently)
            {
               System.err.println("------ exception during close -------");
               anye.printStackTrace();
            }
         }
      }
      if (!silently)
      {
         System.err.println("------------------------------------------------------------------------------------------");
      }
   }

   /**
    * clean up a session
    */
   public static void HandleHibernateException(StatelessSession s, Throwable th)
   {
      HandleHibernateException(s, th, false);
   }

   /**
    * clean up a session
    */
   public static void HandleHibernateException(StatelessSession s, Throwable th, boolean silently)
   {
      if (!silently)
      {
         System.err.println("-------------------------------- HandleHibernateException --------------------------------");
         th.printStackTrace();
      }
      if (s != null)
      {
         try
         {
            s.connection().rollback();
         }
         catch (Exception anye)
         {
            if (!silently)
            {
               System.err.println("------ exception during rollback -------");
               anye.printStackTrace();
            }
         }
         try
         {
            s.close();
         }
         catch (Exception anye)
         {
            if (!silently)
            {
               System.err.println("------ exception during close -------");
               anye.printStackTrace();
            }
         }
      }
      if (!silently)
      {
         System.err.println("------------------------------------------------------------------------------------------");
      }
   }

   // ------------------------------------------------
   // session getters
   // ------------------------------------------------

   public static Session getTestSession()
   {
      Session ans = null;
      try
      {
         HibernateUtils.checkCatalog();
         ans = HibernateUtils.getSessionFactory().openSession();
         ans.connection().setAutoCommit(false);
         ans.connection().setCatalog("pdb2004");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   /**
    * @return Session A Hibernate Session - remember to close it!
    */
   public static Session getSession() throws HibernateException
   {
      Session ans = null;
      try
      {
         HibernateUtils.checkCatalog();
         ans = HibernateUtils.getSessionFactory().openSession();
         ans.connection().setAutoCommit(false);
         ans.connection().setCatalog("pdb2004");
      }
      catch (SQLException e)
      {
         e.printStackTrace();
         throw new HibernateException(e);
      }
      return ans;
   }

   public static StatelessSession getStatelessSession()
   {
      StatelessSession ans = null;
      try
      {
         HibernateUtils.checkCatalog();
         ans = HibernateUtils.getSessionFactory().openStatelessSession();
         ans.connection().setAutoCommit(false);
         ans.connection().setCatalog("pdb2004");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      return ans;
   }

   // ------------------------------------------------
   // schema creation
   // ------------------------------------------------

   public static void checkCatalog()
   {
      Session sess = HibernateUtils.getSessionFactory().openSession();
      try
      {
         sess.connection().setAutoCommit(false);
         sess.connection().setCatalog("pdb2004");
      }
      catch (Exception e1)
      {
         e1.printStackTrace();
         intializePdbSchema(sess.connection());
         try
         {
            sess.connection().setCatalog("pdb2004");
         }
         catch (Exception e2)
         {
            System.err.println("failed during second try - setCatalog pdb2004");
            e2.printStackTrace();
         }
      }
      finally
      {
         if (sess != null)
         {
            sess.close();
         }
      }
   }

   private static final String createdb = "create database pdb2004;";

   private static final String usr1 = "grant all privileges on pdb2004.* to 'pdbdata2'@'localhost' identified by 'lom5ong0' with grant option ;";

   private static final String usr2 = "grant all privileges on pdb2004.* to 'pdbdata2'@'%' identified by 'lom5ong0' with grant option ;";

   private static boolean schemaInitialized = false; // only try once

   public static synchronized void intializePdbSchema(Connection c)
   {
      if (schemaInitialized) return;
      boolean diditwork = false;
      Statement s = null;
      try
      {
         s = c.createStatement();
         diditwork = s.execute(createdb);
         try
         {
            s.execute(usr1);
            s.execute(usr2);
         }
         catch (SQLException usrEx)
         {
            usrEx.printStackTrace();
         }
         s.close();
         s = null;
         schemaInitialized = true;
      }
      catch (SQLException e)
      {
         if (s != null)
         {
            try
            {
               s.close();
            }
            catch (SQLException e1)
            {
               e1.printStackTrace();
            }
         }
         throw new RuntimeException(e);
      }
      System.out.println("intializePdbSchema: " + diditwork);
   }

   // ------------------------------------------------
   // misc
   // ------------------------------------------------

   public static void main(String[] args)
   {
      File[] hmbs = getHbmFiles();
      for (int i = 0; i < hmbs.length; i++)
      {
         File file = hmbs[i];
         try
         {
            System.err.println(file.getCanonicalPath());
         }
         catch (IOException e)
         {
            e.printStackTrace();
         }
      }
      for (int i = 0; i < hmbs.length; i++)
      {
         File file = hmbs[i];
         System.err.println(",\t\t" + file.getName());
      }
   }

   public static File[] getDerivedHbmFiles()
   {
      File[] ans = new File[0];
      File f = new File("src" + File.separator + "org" + File.separator + "pdb" + File.separator + "derived");
      if (f.exists() && f.isDirectory())
      {
         ans = f.listFiles(new HbmFilenameFilter());
      }
      return ans;
   }

   public static File[] getHbmFiles()
   {
      File[] ans = new File[0];
      File f = new File("src" + File.separator + "org" + File.separator + "pdb" + File.separator + "ormapping");
      if (f.exists() && f.isDirectory())
      {
         ans = f.listFiles(new HbmFilenameFilter());
      }
      return ans;
   }

}